#
# This make file is the main make file of the IRIT solid modeller and its
# auxilary tools, under UNIX.
#
#				Gershon Elber, Nov. 1991
#

include makeflag.sas

#
# All subdirectories to recurse into.
#
ALL_DIRS = amigalib xtra_lib misc_lib cagd_lib symb_lib triv_lib trim_lib \
	user_lib prsr_lib geom_lib bool_lib circlink \
	grapdrvs irit poly3d-h irender illustrt filters docs

#
# Uncommend the following variable to only see the actions taken.
#
# VIEW_ONLY = -n

SHELL = /bin/sh

all: 	binaries doc init

#
# Print info regarding initialization.
#
init:
	@echo "Before executing the test suite and/or any usage of this"
	@echo "package you will have to issue the following commands:"
	@echo ""
	@echo "path $(BIN_DIR) add"
	@echo "setenv IRIT_PATH $(BIN_DIR)/"
	@echo "setenv IRIT_DISPLAY \"amidrvs -s-\""
	@echo ""
	@echo "and optionally the following commands:"
	@echo ""
	@echo "setenv IRIT_BIN_IPC 1"
	@echo ""
	@echo "or similar."

binaries:
	-for f in $(ALL_DIRS); do \
		(cd $$f \
		 && /bin/echo ----------- `pwd` ------------- \
		 && make $(VIEW_ONLY) -f makefile.sas install); \
	done
#	-strip $(BIN_DIR)/*

#
# Make hardcopy documentation.
#
doc:
	(cd docs && \
	 make $(VIEW_ONLY) -f makefile.sas irit.tex irit.doc)

clean:
	-rm .~* .\#*			# Emacs backup files.
	-for f in $(ALL_DIRS); do \
		(rm $$f/*.lib $$f/*.o $$f/*mon.out $$f/.~* $$f/.\#* $$f/*mon.out); \
	done
	-rm poly3d-h/*.hdn
	-rm irender/*.rle
	-rm irit/*.dat
	-rm lib/*.lib
	-rm docs/irithlp docs/irithlp.o

#
# Test some of the above programs. Make sure $(BIN_DIR) is in your path
# and that IRIT_LCLDISP is set ('setenv IRIT_LCLDISP x11drvs').
#
test:
	-(cd irit && irit demo)
	-for f in poly3d-h irender illustrt filters; do \
		(cd $$f && csh -f test-unx); \
	done

depend:
	-for f in $(ALL_DIRS); do \
		(cd $$f && makedepend -Y -I../include -fmakefile.unx *.c \
			&& makedepend -Y -I../include -fmakefile.os2 *.c ) \
	done
