/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Main definition Header file for Irit - the 3d (not only polygonal) sm.     *
*****************************************************************************/

#ifndef	PROGRAM_H
#define	PROGRAM_H

#include <setjmp.h>	/* Used for the long jumps - to main iteration loop. */
#include "irit_sm.h"
#include "cagd_lib.h"	   /* We define curves and surfaces handles as well. */
#include "symb_lib.h"
#include "trim_lib.h"
#include "triv_lib.h"
#include "allocate.h"
#include "iritprsr.h"
#include "attribut.h"

#define INPUT_LINE_LEN 2500   		/* Input parser maximum line length. */

#define DEFAULT_LOAD_COLOR 1  /* Default colors for object loaded using LOAD */
#define DEFAULT_PRIM_COLOR 4  /* primitives colors, respectively.	     */

#define DEFAULT_RESOLUTION	20	/* Used in Primitiv/Boolean modules. */
#define DEFAULT_DRAW_CTLPT	FALSE	/* If control mesh/poly to be drawn. */
#define DEFAULT_ECHOSRC		TRUE	            /* Echo sourced program? */
#define DEFAULT_DUMPLVL		1		        /* Min. information. */

#define MACHINE_MSDOS		1
#define MACHINE_SGI		2
#define MACHINE_HP		3
#define MACHINE_APOLLO		4
#define MACHINE_SUN		5
#define MACHINE_UNIX		6
#define MACHINE_IBMOS2		7
#define MACHINE_IBMNT		8
#define MACHINE_AMIGA		9

#define KV_MIN_LEGAL		-9999
#define KV_UNIFORM_OPEN		-10000
#define KV_UNIFORM_FLOAT	-10001
#define KV_UNIFORM_PERIODIC	-10002

extern IPObjectStruct
    *GlblObjList;				   /* All objects on system. */

extern jmp_buf
    GlblLongJumpBuffer;			          /* Used in error recovery. */

extern FILE
    *GlblLogFile;		   /* If do log everything, it goes to here. */

extern int
#ifdef DJGCC		     		   /* Defaults for intr_lib windows. */
    GlblWindowFrameWidth,
    GlblViewFrameColor,
    GlblViewBackColor,
    GlblTransFrameColor,
    GlblTransBackColor,
    GlblStatusFrameColor,
    GlblStatusBackColor,
    GlblInputFrameColor,
    GlblInputBackColor,
    GlblDrawHeader,
    GlblSmoothTextScroll,
    GlblIntrSaveMethod,
    GlblMouseSensitivity,	     /* Sensitivity control of mouse device. */
    GlblJoystickExists,
#endif /* DJGCC */
    GlblDisplayDeviceInput,	   /* Handlers to streams to display device. */
    GlblDisplayDeviceOutput,
    GlblFatalError,		  /* True if disaster in system - must quit! */
    GlblPrintLogFile,		     /* If TRUE everything goes to log file. */
    GlblDoGraphics,		/* Control if running in graphics/text mode. */
    GlblLoadColor,	      /* Default colors for object loaded using LOAD */
    GlblPrimColor;	       /* primitives colors, respectively.	     */

extern char 
#ifdef DJGCC			     /* Defaults for DJGCC intr_lib windows. */
    *GlblViewWndwPos,
    *GlblTransWndwPos,
    *GlblStatusWndwPos,
    *GlblInputWndwPos,
    *GlblIntrSaveDisk,
#endif /* DJGCC */
    *GlblHelpFileName,
    *GlblStartFileName,			/* Name of startup file to executed. */
    *GlblLogFileName,					/* Name of log file. */
    *GlblFloatFormat;	      /* Controls the ways real numbers are printed. */

extern RealType
    GlblPointLen;			       /* Scaler for point if drawn. */

void SetIritState(char *Name, IPObjectStruct *Data);
void IritExit0(void);
void IritExit(int ExitCode);
void DefaultFPEHandler(int Type);

#endif	/* PROGRAM_H */
