/*****************************************************************************
* Module to trap ctrl-brk/hardware error and handle them gracefully.	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 1.1, Mar. 1990   *
*****************************************************************************/

#include <signal.h>
#include <stdio.h>
#include "program.h"
#include "inptprsg.h"
#include "ctrl-brk.h"

typedef void (* SignalFuncPtr)(int);

/*****************************************************************************
* DESCRIPTION:                                                               *
* Routine TrapCtrlC gains control if Control C was typed (DOS level):	     *
*                                                                            *
* PARAMETERS:                                                                *
*   Type:     Type of exception.                                             *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void TrapCtrlC(int Type)
{
    SetUpCtrlBrk();
    FlushToEndOfExpr(FALSE);

#ifndef __WINNT__
    printf("\n*** Break ***\n");
    fflush(stdout);

    longjmp(GlblLongJumpBuffer, 1);
#endif /* __WINNT__ */
}

/*****************************************************************************
* DESCRIPTION:                                                               M
* Routine SetUpCtrlBrk must be called once by main program, at the beginning.M
*                                                                            *
* PARAMETERS:                                                                M
*   None                                                                     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   SetUpCtrlBrk                                                             M
*****************************************************************************/
void SetUpCtrlBrk(void)
{
    if (getenv("IRIT_NO_SIGNALS") == NULL) {
	signal(SIGINT, (SignalFuncPtr) TrapCtrlC);
#if defined(__UNIX__) || defined(OS2GCC)
	signal(SIGQUIT, (SignalFuncPtr) TrapCtrlC);
	signal(SIGKILL, (SignalFuncPtr) IritExit0);
#endif /* __UNIX__ || OS2GCC */
    }
}
