/*****************************************************************************
* Shadow algorithm data structures and definitions interface.		     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Bassarab Dmitri & Plavnik Michael       Ver 0.2, Apr. 1995    *
*****************************************************************************/

#ifndef _ZSHADOW_H_
#define _ZSHADOW_H_

/* We use that data structure to collect information about possibility for   */
/* the one flat to cast a shadow on the other one.                           */
typedef struct SeparateInfoStruct {
    PointType ptMin;             /* Minimal corner of the flat bounding box. */
    PointType ptMax;             /* Maximal corner of the flat bounding box. */
    RealType  dMin;                     /* Minimal distance from the viewer. */
    RealType  dMax;                     /* Maximal distance from the viewer. */
    RealType  lt; /* Plane equation value for current light source location. */
} SeparateInfoStruct;

/* We describe shadow shape on the flat by the polygon, formed from edges.   */
typedef struct ShadowEdgeStruct {
    int x, dx, dy, inc;           /* Polygon scan converting algorithm data. */
    int yMax;                     /* Maximal scan line edge intersects with. */
    int flag;            /* 1 if edge is right edge of the polygon, else -1. */
} ShadowEdgeStruct;

typedef const ShadowEdgeStruct *CPShadowEdgeType;

/******************************************************************************
* here we introduce data structure called "TripplePool" operated as follows:  *
* initialy all the array memory allocated is reserved node after node for     *
* the WAITING nodes, later by activate operation on the WAIT_POOL some of     *
* the WAITING nodes become ACTIVE and are transfered into ACTIVE_POOL. After  *
* performing some operations on the ACTIVE_POOL some nodes become KILLED and  *
* are transfered into KILLED_POOL. The hole number of nodes is preserved.     *
*                                                                             *
*   |----- Killed ----|------ Active -------|------ Waiting ------|           *
*   ^pool             ^active               ^waiting              ^pend       *
******************************************************************************/

typedef struct ShadowEdgePoolStruct {
    ShadowEdgeStruct *Active; 		    /* Points to the active sublist. */
    ShadowEdgeStruct *Waiting;	           /* Points to the waiting sublist. */
    ShadowEdgeStruct *PEnd;	             /* Points just behind the pool. */
    ShadowEdgeStruct *PMax;            /* Temporary pointer inside the pool. */
    ShadowEdgeStruct *Pool;  /* Points to the memory allocated for the pool. */
    int NInside;   /* True if pmax is inside some polygon, false -- outside. */
} ShadowEdgePoolStruct;

typedef const ShadowEdgePoolStruct *CPShadowEdgePoolType;

FlatStruct *GatherShadows(FlatStruct *f);
int IsInShadow(FlatStruct *f, unsigned int LightIndex, unsigned int x);
void ShadowLineInit(FlatStruct *f, unsigned int y);
void ShadowLineIncr(FlatStruct *f, unsigned int y);

#endif
