/******************************************************************************
* User_lib.h - Header file for the User Interaction library.		      *
* This header is also the interface header to the world.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifndef USER_LIB_H
#define USER_LIB_H

#include "cagd_lib.h"
#include "iritprsr.h"

typedef enum {
    USER_ERR_WRONG_SRF,

    USER_ERR_UNDEFINE_ERR
} UserFatalErrorType;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

VoidPtr IntrSrfRayPreprocessSrf(CagdSrfStruct *Srf, int FineNess);
void IntrSrfRayFreePreprocess(VoidPtr Handle);
CagdBType IntrSrfRayTestRay(VoidPtr Handle,
			    CagdPType RayOrigin,
			    CagdVType RayDir,
			    CagdUVType InterUV);
IPPolygonStruct *UserCntrSrfWithPlane(CagdSrfStruct *Srf,
                                      PlaneType Plane,
                                      RealType FineNess);

/******************************************************************************
* Error handling.							      *
******************************************************************************/
char *UserDescribeError(UserFatalErrorType ErrorNum);
void UserFatalError(UserFatalErrorType ErrID);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* USER_LIB_H */
