/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* General, visible to others, definitions of primitiv module.		     *
*****************************************************************************/

#ifndef	PRIMITIV_H
#define	PRIMITIV_H

#define	MIN_RESOLUTION 4

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

IPObjectStruct *PrimGenBOXObject(VectorType Pt,
				 RealType WidthX,
				 RealType WidthY,
				 RealType WidthZ);
IPObjectStruct *PrimGenGBOXObject(VectorType Pt,
				  VectorType Dir1,
				  VectorType Dir2,
				  VectorType Dir3);
IPObjectStruct *PrimGenCONEObject(VectorType Pt, VectorType Dir, RealType R);
IPObjectStruct *PrimGenCONE2Object(VectorType Pt,
				   VectorType Dir,
				   RealType R1,
				   RealType R2);
IPObjectStruct *PrimGenCYLINObject(VectorType Pt, VectorType Dir, RealType R);
IPObjectStruct *PrimGenSPHEREObject(VectorType Center, RealType R);
IPObjectStruct *PrimGenTORUSObject(VectorType Center,
				   VectorType Normal,
				   RealType Rmajor,
				   RealType Rminor);
IPObjectStruct *PrimGenPOLYDISKObject(VectorType N, VectorType T, RealType R);
IPObjectStruct *PrimGenPOLYGONObject(IPObjectStruct *PObjList, int IsPolyline);
IPObjectStruct *PrimGenObjectFromPolyList(IPObjectStruct *PObjList);
IPObjectStruct *PrimGenCROSSECObject(IPObjectStruct *PObj);
IPObjectStruct *PrimGenSURFREVObject(IPObjectStruct *Cross);
IPObjectStruct *PrimGenEXTRUDEObject(IPObjectStruct *Cross, VectorType Dir);

void PrimSetResolution(int Resolution);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* PRIMITIV_H */
