/*****************************************************************************
* General definitions of/for GenMat.c module				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
*****************************************************************************/

#ifndef	GEN_MAT_H
#define GEN_MAT_H

/* And prototypes of the functions: */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void MatGenUnitMat(MatrixType Mat);
void MatGenMatTrans(RealType Tx, RealType Ty, RealType Tz, MatrixType Mat);
void MatGenMatUnifScale(RealType Scale, MatrixType Mat);
void MatGenMatScale(RealType Sx, RealType Sy, RealType Sz, MatrixType Mat);
void MatGenMatRotX1(RealType Teta, MatrixType Mat);
void MatGenMatRotX(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void MatGenMatRotY1(RealType Teta, MatrixType Mat);
void MatGenMatRotY(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void MatGenMatRotZ1(RealType Teta, MatrixType Mat);
void MatGenMatRotZ(RealType CosTeta, RealType SinTeta, MatrixType Mat);

void MatMultTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatAddTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatSubTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatScale4by4(MatrixType MatRes, MatrixType Mat, RealType *Scale);

void MatMultVecby4by4(RealType VRes[3], RealType Vec[3], MatrixType Mat);
void MatMultWVecby4by4(RealType VRes[4], RealType Vec[4], MatrixType Mat);

int MatInverseMatrix(MatrixType M, MatrixType InvM);
RealType MatScaleFactorMatrix(MatrixType M);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* GEN_MAT_H */
