/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   Definitions, visible to others, of Boolean operation modules:	     *
*****************************************************************************/

#ifndef BOOL_LIB_H
#define BOOL_LIB_H

/* Boolean operations types: */
typedef enum {
    BOOL_OPER_OR = 1,
    BOOL_OPER_AND,
    BOOL_OPER_SUB,
    BOOL_OPER_NEG,
    BOOL_OPER_CUT,
    BOOL_OPER_MERGE,
    BOOL_OPER_SELF
} BoolOperType;

typedef struct Bool2DInterStruct {  /* Holds info. on 2D intersetion points. */
    struct Bool2DInterStruct *Pnext;
    IPVertexStruct *Poly1Vrtx, *Poly2Vrtx;  /* Pointer to Pl1/2 inter. vrtx. */
    RealType Param1, Param2;     /* Parametrization along the poly vertices. */
    PointType InterPt;				/* Location of intersection. */
    VectorType Normal;			/* Estimated normal at intersection. */
} Bool2DInterStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Prototypes of the global routines in adjacency.c module: */
int BoolGenAdjacencies(IPObjectStruct *PObj);

/* Prototypes of global functions in bool-2d.c module: */
IPPolygonStruct *Boolean2D(IPPolygonStruct *Pl1,
			   IPPolygonStruct *Pl2,
			   BoolOperType BoolOper);
Bool2DInterStruct *Boolean2DComputeInters(IPPolygonStruct *Pl1,
					  IPPolygonStruct *Pl2,
					  int HandlePolygons);

/* Prototype of the global functions in the Boolean operations module: */
IPObjectStruct *BooleanOR(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanAND(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanSUB(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanNEG(IPObjectStruct *PObj);
IPObjectStruct *BooleanCUT(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanICUT(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanMERGE(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *BooleanSELF(IPObjectStruct *PObj);
int BoolSetOutputInterCurve(int OutputInterCurve);
int BoolSetHandleCoplanarPoly(int HandleCoplanarPoly);
int BoolSetParamSurfaceUVVals(int HandleBoolParamSrfUVVals);
int BoolSetPolySortAxis(int PolySortAxis);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* BOOL_LIB_H */
