/******************************************************************************
* Bbox.h - computes bounding boxes for objects.				      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, June 1993.					      *
******************************************************************************/

#ifndef BBOX_H
#define BBOX_H

#include "iritprsr.h"
#include "cagd_lib.h"

typedef struct BBBboxStruct {
    RealType Min[3];
    RealType Max[3];
} BBBboxStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

BBBboxStruct *BBComputeBboxObject(IPObjectStruct *PObj);
BBBboxStruct *BBComputeBboxObjectList(IPObjectStruct *PObj);
BBBboxStruct *BBComputeOnePolyBbox(IPPolygonStruct *PPoly);
BBBboxStruct *BBComputePolyListBbox(IPPolygonStruct *PPoly);
BBBboxStruct *BBComputePointBbox(RealType *Pt);
BBBboxStruct *BBMergeBbox(BBBboxStruct *Bbox1, BBBboxStruct *Bbox2);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* BBOX_H */
