/*****************************************************************************
* Definitions, visible to others, of the dynamic allocator module.	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#ifndef	ALLOCATE_GH
#define	ALLOCATE_GH

#include "iritprsr.h"
#include "cagd_lib.h"
#include "trim_lib.h"
#include "triv_lib.h"


#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

IPVertexStruct *IPAllocVertex(ByteType Count,
			      ByteType Tags,
			      IPPolygonStruct *PAdj,
			      IPVertexStruct *Pnext);
IPPolygonStruct *IPAllocPolygon(ByteType Count,
				ByteType Tags,
				IPVertexStruct *V,
				IPPolygonStruct *Pnext);
IPObjectStruct *IPAllocObject(char *Name,
			      IPObjStructType ObjType,
			      IPObjectStruct *Pnext);
void IPFreeVertex(IPVertexStruct *V);
void IPFreePolygon(IPPolygonStruct *P);
void IPFreeObject(IPObjectStruct *O);
void IPFreeVertexList(IPVertexStruct *VFirst);
void IPFreePolygonList(IPPolygonStruct *PPoly);
void IPFreeObjectList(IPObjectStruct *O);

int ListObjectLength(IPObjectStruct *PObj);
int ListObjectFind(IPObjectStruct *PObjList, IPObjectStruct *PObj);
void ListObjectInsert(IPObjectStruct *PObjList,
		      int Index,
		      IPObjectStruct *PObjItem);
IPObjectStruct *ListObjectGet(IPObjectStruct *PObjList, int Index);
void ReallocNewTypeObject(IPObjectStruct *PObj, IPObjStructType ObjType);

IPObjectStruct *GenPolyObject(char *Name,
			      IPPolygonStruct *Pl,
			      IPObjectStruct *Pnext);
IPObjectStruct *GenPOLYObject(IPPolygonStruct *Pl);
IPObjectStruct *GenCrvObject(char *Name,
			     CagdCrvStruct *Crv,
			     IPObjectStruct *Pnext);
IPObjectStruct *GenCRVObject(CagdCrvStruct *Crv);
IPObjectStruct *GenSrfObject(char *Name,
			     CagdSrfStruct *Srf,
			     IPObjectStruct *Pnext);
IPObjectStruct *GenSRFObject(CagdSrfStruct *Srf);
IPObjectStruct *GenTrimSrfObject(char *Name,
				 TrimSrfStruct *TrimSrf,
				 IPObjectStruct *Pnext);
IPObjectStruct *GenTRIMSRFObject(TrimSrfStruct *TrimSrf);
IPObjectStruct *GenTrivarObject(char *Name,
				TrivTVStruct *Triv,
				IPObjectStruct *Pnext);
IPObjectStruct *GenTRIVARObject(TrivTVStruct *Triv);
IPObjectStruct *GenCtlPtObject(char *Name,
			       CagdPointType PtType,
			       CagdRType *CagdCoords,
			       RealType *Coords,
			       IPObjectStruct *Pnext);
IPObjectStruct *GenCTLPTObject(CagdPointType PtType,
			       CagdRType *CagdCoords,
			       RealType *Coords);
IPObjectStruct *GenNumObject(char *Name, RealType *R, IPObjectStruct *Pnext);
IPObjectStruct *GenNUMObject(RealType *R);
IPObjectStruct *GenNUMValObject(RealType R);
IPObjectStruct *GenPtObject(char *Name,
			    RealType *Pt0,
			    RealType *Pt1,
			    RealType *Pt2,
			    IPObjectStruct *Pnext);
IPObjectStruct *GenPTObject(RealType *Pt0, RealType *Pt1, RealType *Pt2);
IPObjectStruct *GenVecObject(char *Name,
			     RealType *Vec0,
			     RealType *Vec1,
			     RealType *Vec2,
			     IPObjectStruct *Pnext);
IPObjectStruct *GenVECObject(RealType *Vec0, RealType *Vec1, RealType *Vec2);
IPObjectStruct *GenStrObject(char *Name, char *Str, IPObjectStruct *Pnext);
IPObjectStruct *GenSTRObject(char *Str);
IPObjectStruct *GenPlaneObject(char *Name,
			       RealType *Plane0,
			       RealType *Plane1,
			       RealType *Plane2,
			       RealType *Plane3,
			       IPObjectStruct *Pnext);
IPObjectStruct *GenPLANEObject(RealType *Plane0,
			       RealType *Plane1,
			       RealType *Plane2,
			       RealType *Plane3);
IPObjectStruct *GenMatObject(char *Name,
			     MatrixType Mat,
			     IPObjectStruct *Pnext);
IPObjectStruct *GenMATObject(MatrixType Mat);

IPObjectStruct *CopyObject(IPObjectStruct *Dest,
			   IPObjectStruct *Src,
			   int CopyAll);

IPObjectStruct *CopyObjectList(IPObjectStruct *PObjs, int CopyAll);
IPPolygonStruct *CopyPolygonList(IPPolygonStruct *Src);
IPVertexStruct *CopyVertexList(IPVertexStruct *Src);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* ALLOCATE_GH */
