/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Global definitions of	wntdrvs interface.			             *
*****************************************************************************/

#ifndef	WNTDRVS_H	/* Define only once */
#define	WNTDRVS_H

#define APP_CLASS		"wntdrvs"
#define APP_TITLE		"Irit Display Device"
#define APP_MENU		1000
#define APP_VIEW_CLASS		"IritViewClass"
#define APP_TRANS_CLASS		"IritTransClass"

#define IDM_FILE		1
#define IDM_FILE_SAVE		11
#define IDM_FILE_SAVE_AS	12
#define IDM_FILE_QUIT		13

#define IDM_MOUSE		2
#define IDM_MOUSE_MORE		21
#define IDM_MOUSE_LESS		22

#define IDM_STATE		3
#define IDM_STATE_MORE_ISO	31
#define IDM_STATE_LESS_ISO	32
#define IDM_STATE_FINER_APPROX	33
#define IDM_STATE_COARSER_APPROX 34
#define IDM_STATE_SHORTER_VEC	35
#define IDM_STATE_LONGER_VEC	36
#define IDM_STATE_WIDE_LINES	37
#define IDM_STATE_THIN_LINES	38
#define IDM_STATE_WIDE_POINTS	39
#define IDM_STATE_THIN_POINTS	40

#define IDM_TOGGLE		5
#define IDM_TGLS_SCREEN		51
#define IDM_TGLS_PERSP		52
#define IDM_TGLS_DEPTH_CUE	53
#define IDM_TGLS_DOUBLE_BUFFER  54
#define IDM_TGLS_DRAW_SOLID	55
#define IDM_TGLS_BFACE_CULL	56
#define IDM_TGLS_SHADING_MODES  57
#define IDM_TGLS_INTERNAL	58
#define IDM_TGLS_VRTX_NRML	59
#define IDM_TGLS_POLY_NRML	60
#define IDM_TGLS_CTL_MESH	61
#define IDM_TGLS_SRF_POLYS	62
#define IDM_TGLS_4_PER_FLAT	63

#define	IDM_VIEWS		7
#define	IDM_VIEW_FRONT		70
#define IDM_VIEW_SIDE		71
#define IDM_VIEW_TOP		72
#define IDM_VIEW_ISOMETRY	73

#define IDM_ANIMS		8
#define IDM_ANIM_ANIMATION	80

#define IDD_ANIMATION_FORM              101
#define IDD_ANIMATION_FRAME             102
#define IDD_PROMPT                      103
#define IDB_BITMAP_PLAYBACK             104
#define IDB_BITMAP_REWIND               104
#define IDB_BITMAP_PLAYBACKWARD         105
#define IDB_BITMAP_STOP                 106
#define IDB_BITMAP_PLAY                 107
#define IDB_BITMAP_FORWARD              108

#define IDC_BUTTON_RESTART              1000
#define IDC_STATIC_PICTURE              1002
#define IDC_BUTTON_REWIND               1004
#define IDC_BUTTON_PLAYBACK             1005
#define IDC_BUTTON_PLAYBACKWARD         1005
#define IDC_BUTTON_STOP                 1006
#define IDC_BUTTON_PLAY                 1007
#define IDC_BUTTON_FORWARD              1008
#define IDC_BUTTON_MINTIME              1009
#define IDC_BUTTON_MAXTIME              1010
#define IDC_BUTTON_INTERVALDT           1011
#define IDC_BUTTON_FASTINTERVALDT       1012
#define IDC_BUTTON_SSTEP                1013
#define IDC_TRACKBAR_SCALE              1014
#define IDC_STATIC_SCALENAME            1015
#define IDC_BUTTON_SINGLESTEP           1019
#define IDC_EDIT_SELECTION              1020
#define IDC_BUTTON6                     1022
#define IDC_SCROLLBAR1                  1022
#define IDC_BUTTON7                     1023
#define IDC_BUTTON8                     1024
#define IDC_BUTTON9                     1025
#define IDC_BUTTON10                    1026
#define IDC_STATIC_SELCTIONLABEL        2000
#define IDC_STATIC_TAG1                 -1
#define IDC_STATIC_SCALETITLE           -1

#define DEFAULT_TRANS_WIDTH	200
#define DEFAULT_TRANS_HEIGHT	500
#define DEFAULT_VIEW_WIDTH	400
#define DEFAULT_VIEW_HEIGHT	400
                                   
#define ARGCV_LINE_LEN	1000
#define ARGCV_MAX_WORDS	100

#define WNT_MAP_X_COORD(x) ((int) (IGViewWidth2 + x * IGViewWidth2))
#define WNT_MAP_Y_COORD(y) ((int) (IGViewHeight2 - y * IGViewHeight2))

#define SET_MENU_FLAGS(Bool)  (MF_STRING | (Bool ? MF_CHECKED : 0))

extern unsigned int
    IGViewWidth,
    IGViewHeight,
    IGViewWidth2,
    IGViewHeight2;
extern HBRUSH
    IGBackGroundBrush;
extern COLORREF
    IGBackGroundColor,
    IGCrntColorLowIntensity,
    IGCrntColorHighIntensity,
    IGColorsLowIntensity[IG_MAX_COLOR + 1],
    IGColorsHighIntensity[IG_MAX_COLOR + 1];
extern HPEN
    IGCurrenthPen;
extern HWND
    IGhWndView, IGhWndTrans, IGhTopLevel;
extern HDC
    IGCurrenthDC;
extern HMENU
    IGGlblStateMenu;

int RedrawViewWindow(HWND hWnd, UINT wMsg, WPARAM wParam);
void IGSetColorIndex(int c);
void IGSetColorIndex2(int color, int width);
void IGSetColorRGB(int Color[3]);
void IGIritBeep(void);
void IGIritError(const char* szTitle, const char* szFormat, ...);

/* anim_wnt.c */
void CreateAnimation(HWND); 
void AnimationCB(void);
void ReplaceLabel(HWND, char* NewLabel);

#endif /* WNTDRVS_H */
