/*****************************************************************************
* Conversion routines from curvesand surfaces to polygons and polylines.     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 1.0, Apr 1992    *
*****************************************************************************/

#ifndef FF_CONVRT_H
#define FF_CONVRT_H

#include "iritprsr.h"
#include "attribut.h"
#include "cagd_lib.h"
#include "trim_lib.h"
#include "triv_lib.h"

typedef struct FreeformConvState {
    int	      Talkative;                      /* If TRUE, be more talkative. */
    int	      DumpObjsAsPolylines;  /* Should we dump polylines or polygons. */
    int	      DrawFFGeom;           /* Should we dump the freeform geometry. */
    int	      DrawFFMesh;         /* Should we dump control polygons/meshes. */
    int       NumOfIsolines[3];    /* isolines for surfaces and trivariates. */
    int       SamplesPerCurve;      /* How many samples per isoparam. curve. */
    int	      OptimalPolylines;          /* Optimal (or not optimal) approx. */
    int       ShowInternal;       /* Do we display internal polygonal edges? */
    int	      CubicCrvsAprox;	   /* Do curves should be approx. as cubics. */
    RealType  FineNess;         /* Control over the polygonal approximation. */
    int	      ComputeUV;    /* Attach UV attributes to vertices of polygons. */
    int	      FourPerFlat;          /* Two or four triangles per flat patch. */
    int	      OptimalPolygons;           /* Optimal (or not optimal) approx. */
    int	      BBoxGrid;           /* Compute bbox/grid subdivision for bbox. */
    int	      LinearOnePolyFlag;/* Only one polygonal subdiv. along linears. */
} FreeformConvState;

extern FreeformConvState FFCState;

IPPolygonStruct *Curve2Polylines(CagdCrvStruct *Crv, int DrawCurve,
				 int DrawCtlPoly, int SamplesPerCurve,
				 int OptimalPolyline);
IPPolygonStruct *Surface2Polylines(CagdSrfStruct *Srf, int DrawSurface,
				   int DrawMesh, int NumOfIsolines[2],
				   int SamplesPerCurve, int OptimalPolylines);
IPPolygonStruct *TSrf2Polylines(TrimSrfStruct *TrimSrf,
				int DrawSurface,
				int DrawMesh,
				int NumOfIsolines[2],
				int SamplesPerCurve,
				int OptimalPolylines);
IPPolygonStruct *TV2Polylines(TrivTVStruct *Trivar,
			      int DrawTrivar,
			      int DrawMesh,
			      int NumOfIsolines[3],
			      int SamplesPerCurve,
			      int OptimalPolylines);
IPObjectStruct *FreeForm2Polylines(IritPrsrFreeFormStruct *FreeForms,
				   int Talkative,
				   int DrawGeom,
				   int DrawMesh,
				   int NumOfIsolines[3],
				   int SamplesPerCurve,
				   int OptimalPolylines);
IPObjectStruct *FreeForm2CubicBzr(IritPrsrFreeFormStruct *FreeForms,
				  int Talkative,
				  int DrawGeom,
				  int DrawMesh,
				  int NumOfIsolines[3],
				  int SamplesPerCurve,
				  int OptimalPolylines);
IPObjectStruct *FreeForm2Polygons(IritPrsrFreeFormStruct *FreeForms,
				  int Talkative,
				  int FourPerFlat,
				  int FineNess,
				  int ComputeUV,
				  int Optimal,
				  int BBoxGridFlag);
IPObjectStruct *ProcessFreeForm(IPObjectStruct *PObj,
				FreeformConvState *State);

#endif /* FF_CONVRT_H */
