/*****************************************************************************
* Filter to convert between textand binary IRIT data files.     	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 1.0, Dec 1994    *
*****************************************************************************/


#ifdef USE_VARARGS
#include <varargs.h>
#else
#include <stdarg.h>
#endif /* USE_VARARGS */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include "irit_sm.h"
#include "iritprsr.h"
#include "attribut.h"
#include "allocate.h"
#include "iritgrap.h"
#include "getarg.h"
#include "genmat.h"
#include "ffcnvrt.h"
#include "ip_cnvrt.h"


#ifdef NO_CONCAT_STR
static char *VersionStr =
	"Dat2bin		Version 6.0,	Gershon Elber,\n\
	 (C) Copyright 1989/90-95 Gershon Elber, Non commercial use only.";
#else
static char *VersionStr = "Dat2bin	" VERSION ",	Gershon Elber,	"
	__DATE__ ",   " __TIME__ "\n" COPYRIGHT ", Non commercial use only.";
#endif /* NO_CONCAT_STR */

static char
    *CtrlStr = "dat2bin t%- z%- DFiles!*s";

static void D2BExit(int ExitCode);

/*****************************************************************************
* DESCRIPTION:                                                               M
* Main module of skeletn1 - Read command line and do what is needed...	     M
*                                                                            *
* PARAMETERS:                                                                M
*   argc, argv:  Command line.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
void main(int argc, char **argv)
{
    IPObjectStruct *PObjects, *PObj;
    int Error, i, Handler,
	TextFormatOutputFlag = FALSE,
	VerFlag = FALSE,
	NumFiles = 0;
    char
	**FileNames = NULL;

    if ((Error = GAGetArgs(argc, argv, CtrlStr, &TextFormatOutputFlag,
			   &VerFlag, &NumFiles, &FileNames)) != 0) {
	GAPrintErrMsg(Error);
	GAPrintHowTo(CtrlStr);
	D2BExit(1);
    }

    if (VerFlag) {
	fprintf(stderr, "\n%s\n\n", VersionStr);
	GAPrintHowTo(CtrlStr);
	D2BExit(0);
    }

    /* Get the data files: */
    IritPrsrSetFlattenObjects(FALSE);
    if ((PObjects = IritPrsrGetDataFiles(FileNames, NumFiles, TRUE, FALSE)) ==
									NULL)
	D2BExit(1);

    if (PObjects -> Pnext != NULL) {
	/* Convert into a list object. */
	PObj = IPAllocObject("", IP_OBJ_LIST_OBJ, NULL);
	for (i = 0; PObjects != NULL; i++, PObjects = PObjects -> Pnext)
	    ListObjectInsert(PObj, i, PObjects);
	ListObjectInsert(PObj, i, NULL);
	for (i = 0; (PObjects = ListObjectGet(PObj, i)) != NULL; i++)
	    PObjects -> Pnext = NULL;
	PObjects = PObj;
    }

    Handler = IritPrsrOpenStreamFromFile(stdout, FALSE,
					 !TextFormatOutputFlag, FALSE);
    IritPrsrPutObjectToHandler(Handler, PObjects);

    IritPrsrCloseStream(Handler, TRUE);
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* D2BExit exit routine.							     *
*                                                                            *
* PARAMETERS:                                                                *
*   ExitCode:                                                                *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void D2BExit(int ExitCode)
{
    exit(ExitCode);
}

#ifdef DEBUG

/*****************************************************************************
* DESCRIPTION:                                                               *
*    Dummy function to link at debugging time.                               *
*                                                                            *
* PARAMETERS:                                                                *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*                                                                            *
* KEYWORDS:                                                                  *
*****************************************************************************/
void DummyLinkCagdDebug(void)
{
    IritPrsrDbg();
}

#endif /* DEBUG */
