#include "ooglutil.h"
#include "geom.h"
#include "meshP.h"
#include "pointlistP.h"


void *mesh_PointList_get(int sel, Geom *geom, va_list args);
void *mesh_PointList_fillin(int sel, Geom *geom, va_list args);
void *mesh_PointList_set(int sel, Geom *geom, va_list args);
void *mesh_PointList_length(int sel, Geom *geom, va_list args);

#define MAX_METHODS 4

static SpecFunc methods[] = {
  "PointList_get", mesh_PointList_get,
  "PointList_fillin", mesh_PointList_fillin,
  "PointList_set", mesh_PointList_set,
  "PointList_length", mesh_PointList_length
};

static char msg[] = "ptlMesh.c";

ptlMesh_init() {
  pointlist_initspec(methods, MAX_METHODS, GeomClassLookup("mesh"));
}

void *mesh_PointList_get(int sel, Geom *geom, va_list args) {
  HPoint3 *pt;
  Mesh *m = (Mesh *)geom;
  float **f;
  pt = OOGLNewNE(HPoint3, m->nu * m->nv, msg);
  f = va_arg(args, float **);
  return GeomCall(GeomMethodSel("PointList_fillin"), geom, f, 0, pt);
}

void *mesh_PointList_fillin(int sel, Geom *geom, va_list args) {
  HPoint3 *pt;
  float **t;
  Mesh *m = (Mesh *)geom;

  t = va_arg(args, float **);
  va_arg(args, int);
  pt = va_arg(args, HPoint3 *);

  bcopy(m->p, pt, m->nu * m->nv * sizeof(HPoint3));
  HPt3TransformN(t, pt, pt, m->nu * m->nv);

  return pt;
}

void *mesh_PointList_set(int sel, Geom *geom, va_list args) {
  Mesh *m = (Mesh *)geom;
  HPoint3 *plist;

  /* This will make the mesh no longer a z-mesh (in general, this
   * is desirable although we may regret it later */
  m->flag &= ~MESH_Z;

  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);
  bcopy(plist, m->p, m->nu * m->nv * sizeof(HPoint3));
  return geom;
}

void *mesh_PointList_length(int sel, Geom *geom, va_list args) {
  Mesh *m = (Mesh *)geom;
  return((void *)(m->nu * m->nv));
}
