/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdarg.h>
#include "ooglutil.h"


char	*_GFILE;	/* Name of file where error is found */
int	_GLINE;		/* Line number in file where error is found */
int	OOGL_Errorcode;	/* Unique integer error code */

int _OOGLError(int errorcode,char* fmt,...)
{
   va_list args;
   va_start(args, fmt);
   if(errorcode & OE_VERBOSE)
	fprintf(stderr, "Error <%d>: ",errorcode);
   if (fmt != NULL) vfprintf(stderr, fmt, args);
   fprintf(stderr, "\n");
   if(errorcode & OE_VERBOSE)
	fprintf(stderr, "File: %s, Line: %d\n\n",_GFILE,_GLINE);
   OOGL_Errorcode = errorcode;
   va_end(args);
   return 0;
}

/*
 * Report syntax error
 */
void OOGLSyntax(FILE *f, char *fmt, ...)
{
   static FILE *oldf;
   static FILE oldfile;
   static char oldtext[32];
   char *context;

   va_list args;
   va_start(args, fmt);
   vfprintf(stderr, fmt, args);
   context = fcontext(f);
   if(f == oldf && memcmp(f, &oldfile, sizeof(FILE)) == 0 &&
			strcmp(context, oldtext) == 0) {
	fprintf(stderr, " [ditto]\n");
   } else {
	fprintf(stderr,
	    context[0] != '\0' ? ":\n%s" : " [no text available]\n",
	    context);
	oldf = f;
	oldfile = *f;
	memcpy(oldtext, context, sizeof(oldtext));
	oldtext[sizeof(oldtext)-1] = '\0';
   }
   va_end(args);
}

void GeomWarn(char *fmt, ...)
{
  int level = 2;
  va_list args;
  
  if(fmt[0] < ' ' && fmt[0] != '\0')
    level = *fmt++;
  /* Maybe we have a current warning level below which we don't print */

  va_start (args, fmt);
  
  vfprintf (stderr, fmt, args);
  fputc('\n', stderr);
  fflush(stderr);
  va_end (args);
}

char *
sperrno(unsigned int err)
{
  extern int sys_nerr;
  extern char *sys_errlist[];
  static char errstr[16];
  
  if(err < sys_nerr)
    return(sys_errlist[err]);
  sprintf(errstr, "Error %d", err & 0xffff);
  return(errstr);
}

char *
sperror(void)
{
	extern int errno;

	return sperrno(errno);
}
