#include <limits.h>
#include "mgP.h"
#include "mgx11P.h"
#include "windowP.h"
#include "mgx11windows.h"

#ifdef AIX
#include "/usr/lpp/X11/Xamples/extensions/lib/XShm.c"
#endif

#define THEIGHT 200
#define TWIDTH 200
#define MAX(a,b) (((a)<(b)) ? b : a)
#define MIN(a,b) (((a)<(b)) ? a : b)

static mgx11_sort *mgx11sort = NULL;	/* global sorting structure */
static Display *mgx11display = NULL;	/* global X display pointer */

/* Z-buffer */
static float *mgx11zbuffer = NULL;
static int mgx11zsize = 0;

/* Dithering stuff  ... fun fun fun :-) */
int colorlevels = 6;			/* try 220 levels for starters */
unsigned long mgx11colors[217];
static XColor mgx11colorcells[217];
static Colormap	cmap;
int mgx11multab[256];			/* premultiplied table for speed */
static ColorA black = {0.0, 0.0, 0.0, 0.0 };
static int curwidth = 1;
static int shm_message_shown = 0;

extern void dithermap(int, double, int [][3]);
extern unsigned long dithergb(int, int, int *, int);

/* X Error stuff */
static int globalXError;

/*
   Function: myXErrorHandler
   Description: handle error if shared memory is unavailable
   Author: Tim Rowley
*/
int myXErrorHandler(Display *d, XErrorEvent *e)
{
	globalXError = 1;
	return 1;
}

/*
   Function: Xmg_setx11display
   Description: digest info about this display, allocate space for colors
   Author: Daeron Meyer
*/
void Xmg_setx11display(Display *dpy)
{
  XColor	col;
  int		colfail = 1, i;
  unsigned int	nplanes = 0;
  unsigned long	planemasks[1];
  int		rgbmap[216][3];
  int		cube;

  _mgx11c->mgx11display = dpy;

  if (mgx11display == dpy)
    return;

  mgx11display = dpy;

  if (_mgx11c->bitdepth == 1)  /* We are on a black and white screen! */
    return;

  if (_mgx11c->bitdepth == 24)  /* We are on a TrueColor screen! */
  {
    colorlevels = 0;
    return;
  }

  if (_mgx11c->pix)
  {
    cmap = XCreateColormap(mgx11display, DefaultRootWindow(mgx11display),
			    DefaultVisual(mgx11display,
			    DefaultScreen(mgx11display)),
			    AllocNone);
  }
  else {
    if (!_mgx11c->cmapset)
      cmap = DefaultColormapOfScreen(DefaultScreenOfDisplay(mgx11display));
    else
      cmap = _mgx11c->cmap;
  }

  while (colfail && colorlevels > 1)
  {
    if (XAllocColorCells(dpy, cmap, False, planemasks, nplanes, mgx11colors,
		 (unsigned int)(colorlevels*colorlevels*colorlevels+1)))
      colfail = 0;
    else
      colorlevels--;
  }

  if (colfail)
  {
    fprintf(stderr, "Couldn't allocate enough colors. Try closing other X apps first.\n");
    exit(0);
  }

  cube = colorlevels * colorlevels * colorlevels;

  for (i = 0; i <= cube; i++)
    mgx11colorcells[i].pixel = mgx11colors[i];

  dithermap(colorlevels, (double)1.0, rgbmap);

  for (i = 0; i < cube; i++)
  {
    mgx11colorcells[i].red = (unsigned short)(rgbmap[i][0] * 256);
    mgx11colorcells[i].green = (unsigned short)(rgbmap[i][1] * 256);
    mgx11colorcells[i].blue = (unsigned short)(rgbmap[i][2] * 256);
    mgx11colorcells[i].flags = DoRed | DoGreen | DoBlue;
  }

  XStoreColors(dpy, cmap, mgx11colorcells, cube + 1);

  for (i=0; i<256; i++)
	mgx11multab[i] = colorlevels*i;
}

/*
   Function: Xmg_initx11device
   Description: allocate space for the display list, initialize mgcontext
   Author: Daeron Meyer
*/
int Xmg_initx11device()
{

  if (!mgx11sort)
  {
    mgx11sort = (mgx11_sort *)malloc(sizeof(mgx11_sort));
    mgx11sort->primnum = 1000;
    VVINIT(mgx11sort->primsort, int, mgx11sort->primnum);
    vvneeds(&(mgx11sort->primsort), mgx11sort->primnum);
    VVINIT(mgx11sort->prims, mgx11prim, mgx11sort->primnum);
    vvneeds(&(mgx11sort->prims), mgx11sort->primnum);

    mgx11sort->pvertnum = 2024;
    VVINIT(mgx11sort->pverts, CPoint3, mgx11sort->pvertnum);
    vvneeds(&(mgx11sort->pverts), mgx11sort->pvertnum);
/*    fprintf(stderr,"Allocated prims and vertices\n"); */

  }
  _mgx11c->mysort = mgx11sort;
  _mgx11c->myxwin = NULL;
  _mgx11c->bitdepth = 0;
  _mgx11c->visual = NULL;
  _mgx11c->noclear = 0;
  return 1;

}

/*
   Function: Xmg_initzrange
   Description: obsolete
*/
void Xmg_initzrange()
{
/*
  fprintf(stderr,"X11: initialize Z-buffer\n");
  */
}

/*
   Function: Xmg_openwin
   Description: open a window if we haven't been given one to draw into
   Author: Daeron Meyer
*/
int Xmg_openwin(char *id)
{
  mgx11win *current;
  int      border_width = 0;
  int	   border_color, bg_color;
  int	bitmap_pad;
  XErrorHandler handler;

  if (!_mgx11c->bitdepth)
	_mgx11c->bitdepth = 8;

  if (!mgx11display)
    Xmg_setx11display(XOpenDisplay(NULL));

  if (!_mgx11c->visual)
	_mgx11c->visual = DefaultVisual(mgx11display,
				DefaultScreen(mgx11display));

  border_color = WhitePixel(_mgx11c->mgx11display,
		DefaultScreen(_mgx11c->mgx11display));
  bg_color = BlackPixel(_mgx11c->mgx11display,
		DefaultScreen(_mgx11c->mgx11display));

/*  fprintf(stderr,"X11: open a window, name = %s\n",id); */

  if (_mgx11c->myxwin == NULL)
    _mgx11c->myxwin = (mgx11win *)malloc(sizeof(mgx11win));

  current = _mgx11c->myxwin;
  current->window = XCreateSimpleWindow(_mgx11c->mgx11display,
 			DefaultRootWindow(_mgx11c->mgx11display), 0, 0, TWIDTH,
			THEIGHT, border_width, border_color, bg_color);
  XStoreName(_mgx11c->mgx11display, current->window, id);
  
  current->xswa.colormap = DefaultColormap(_mgx11c->mgx11display,
			DefaultScreen(_mgx11c->mgx11display));
  current->xswa.backing_store = Always;
  current->xswa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(_mgx11c->mgx11display, current->window,
			CWBitGravity, &(*current).xswa);

  current->gc = XCreateGC(_mgx11c->mgx11display, current->window, 0, NULL);
  XSetForeground(_mgx11c->mgx11display, current->gc,
	WhitePixel(_mgx11c->mgx11display,
	DefaultScreen(_mgx11c->mgx11display)));
  XSetBackground(_mgx11c->mgx11display, current->gc, bg_color);
  XMapWindow(_mgx11c->mgx11display, current->window);
  XClearWindow(_mgx11c->mgx11display, current->window);

  current->image = NULL;
  if (XShmQueryExtension(_mgx11c->mgx11display) == True)
  {
      current->image = 
	  XShmCreateImage(_mgx11c->mgx11display, _mgx11c->visual, 
			  _mgx11c->bitdepth, ZPixmap, NULL, &(current->shminf),
			  TWIDTH, THEIGHT);
  }

  _mgx11c->shm = 0;  
  if (current->image != NULL)
  {
      _mgx11c->shm = 1;
      current->shminf.shmid = 
	  shmget(IPC_PRIVATE, current->image->bytes_per_line *
		 current->image->height, IPC_CREAT|0777);
      current->buf =
	  shmat(current->shminf.shmid, NULL, 0);
      current->shminf.shmaddr = current->image->data = (char *)current->buf;
      current->shminf.readOnly = True;
      globalXError = 0;
      handler = XSetErrorHandler(myXErrorHandler);
      XShmAttach(_mgx11c->mgx11display, &(current->shminf));
      XSync(_mgx11c->mgx11display, False);
      XSetErrorHandler(handler);
      shmctl(current->shminf.shmid, IPC_RMID, 0);
      if (globalXError == 1)
      {
	   _mgx11c->shm = 0;
	   shmdt(current->shminf.shmaddr);
       }
  }
  if (_mgx11c->shm == 0)
  {
      if (!shm_message_shown)
      {
        fprintf(stderr, "Shared memory unavailable, using fallback display method.\n");
        shm_message_shown = 1;
      }

      switch (_mgx11c->bitdepth)
      {
	case 1:
	case 8: bitmap_pad = 8; break;
	case 24: bitmap_pad = 32; break;
	default: fprintf(stderr, "Unknown bit depth %d\n", _mgx11c->bitdepth);
      }
      current->image =
	  XCreateImage(_mgx11c->mgx11display, _mgx11c->visual,
		       _mgx11c->bitdepth, ZPixmap, 0, NULL, TWIDTH, THEIGHT,
		       bitmap_pad, 0);
      current->buf = 
	  (unsigned char *)malloc(current->image->bytes_per_line * current->image->height);
      current->image->data = (char *) current->buf;
  }

  current->width = current->image->bytes_per_line;
  current->height = current->image->height;
  current->zwidth = TWIDTH;
  if (current->width*current->height > mgx11zsize)
  {
      mgx11zsize = current->width*current->height;
      if (!mgx11zbuffer)
        mgx11zbuffer = (float *) malloc(sizeof(float)*mgx11zsize);
      else
        mgx11zbuffer = (float *) realloc((void *)mgx11zbuffer,
				       sizeof(float)*mgx11zsize);
  }
  _mgx11c->sortmethod = MG_ZBUFFER;
  _mgx11c->dither = 1;
/* TOR */

/*  fprintf(stderr,"bitplanes = %d\n", (int)DefaultDepth(_mgx11c->mgx11display,
				  DefaultScreen(_mgx11c->mgx11display))); */
  _mgx11c->myxwin = current;
  return 1;
}

/*
   Function: Xmg_setparent
   Description: set parent window for current context
   Author: Daeron Meyer
*/
void Xmg_setparent(Window win)
{
  _mgx11c->myxwin->parent = win;
}

/*
   Function: Xmg_setwin
   Description: set window for current context and get colormap if its a pix
   Author: Daeron Meyer
*/
void Xmg_setwin(Window win)
{
  mgx11win *current;
  int toss;
  int bg_color = BlackPixel(_mgx11c->mgx11display,
		DefaultScreen(_mgx11c->mgx11display));

/*  fprintf(stderr, "X11: doing setwin\n"); */
  if (_mgx11c->myxwin == NULL)
    _mgx11c->myxwin = (mgx11win *)malloc(sizeof(mgx11win));

  _mgx11c->visible = 1;
  _mgx11c->myxwin->window = win;
  current = _mgx11c->myxwin;
  if (!_mgx11c->pix)
  {
    current->xswa.colormap = DefaultColormap(_mgx11c->mgx11display,
                        DefaultScreen(_mgx11c->mgx11display));
    current->xswa.backing_store = Always;
    current->xswa.bit_gravity = CenterGravity;
    XChangeWindowAttributes(_mgx11c->mgx11display, current->window,
                        CWBitGravity, &(*current).xswa);
  }

  current->gc = XCreateGC(_mgx11c->mgx11display, win, 0, NULL);
  current->image = NULL;
  Xmg_getwinsize(&toss, &toss, &toss, &toss);
  XSetForeground(_mgx11c->mgx11display, current->gc,
	WhitePixel(_mgx11c->mgx11display,
	DefaultScreen(_mgx11c->mgx11display)));
  XSetBackground(_mgx11c->mgx11display, current->gc, bg_color);
  if (!_mgx11c->pix)
    XClearWindow(_mgx11c->mgx11display, current->window);
  _mgx11c->sortmethod = MG_ZBUFFER;
  _mgx11c->dither = 1;
  _mgx11c->noclear = 0;
/*  fprintf(stderr, "X11: finish setwin\n"); */
}

/*
   Function: Xmg_poswin
   Description: currently nonfunctional... will eventually call callback
   Author: Daeron Meyer
*/
void Xmg_poswin(int x1, int y1, int x2, int y2)
{
/*  fprintf(stderr,"X11: position window %d %d %d %d\n",x1,y1,x2,y2); */
}

/*
   Function: Xmg_prefposwin
   Description: currently nonfunctional... will eventually call callback
   Author: Daeron Meyer
*/
void Xmg_prefposwin(int x1, int y1, int x2, int y2)
{
/*  fprintf(stderr,"X11: preferred position window %d %d %d %d\n",x1,y1,x2,y2);
 */
}

/*
   Function: Xmg_prefposwin
   Description: resize window if its size isn't locked
   Author: Daeron Meyer
*/
void Xmg_sizewin(int x, int y)
{
  if (_mgx11c->sizelock)
    return;
/*  fprintf(stderr,"X11: size window %d %d\n",x, y); */

  if (!_mgx11c->pix)
    XResizeWindow(_mgx11c->mgx11display, _mgx11c->myxwin->window,
	(unsigned int) x, (unsigned int) y);
}

/*
   Function: Xmg_minsize
   Description: nonfunctional
   Author: Daeron Meyer
*/
void Xmg_minsize(int x, int y)
{
/*  fprintf(stderr,"X11: minimum size of window %d %d\n",x, y); */
}

/* ditto */
void Xmg_winconstrain()
{
/*  fprintf(stderr,"X11: window constrain\n"); */
}

/* ditto */
void Xmg_titlewin(char *name)
{
/*  fprintf(stderr,"X11: title window: %s\n",name); */
}

/*
   Function: Xmg_closewin
   Description: close window and free shared memory
   Author: Daeron Meyer, Tim Rowley
*/
void Xmg_closewin(mgx11win *this)
{
  Display *dpy = _mgx11c->mgx11display;

/*
  fprintf(stderr, "X11: Destroyed shm/closing window id=%d\n", this->mgwinid);
*/
  if (_mgx11c->shm)
  {
      XShmDetach(dpy, &(this->shminf));
      shmdt(this->shminf.shmaddr);
  }
  XDestroyImage(this->image);
}

/*
   Function: Xmg_choosewin
   Description: nonfunctional
   Author: Daeron Meyer
*/
void Xmg_choosewin(int id)
{
/*  fprintf(stderr,"X11: choose a window\n"); */
}

/*
   Function: Xmg_flush
   Description: flush connection to X
   Author: Daeron Meyer
*/
void Xmg_flush()
{
  XFlush(_mgx11c->mgx11display);
/*  fprintf(stderr,"X11: XFlush\n"); */
}

/*
   Function: Xmg_newdisplaylist
   Description: initialize display list
   Author: Daeron Meyer
*/
void Xmg_newdisplaylist()
{
/*  fprintf(stderr,"X11: Start Display List\n"); */

  _mgx11c->mysort->cprim = 0;
  _mgx11c->mysort->cvert = 0;
  _mgx11c->mysort->maxverts = 0;
  _mgx11c->znudgeby = 0.0;
  _mgx11c->oxmin = _mgx11c->xmin; _mgx11c->oymin = _mgx11c->ymin;
  _mgx11c->oxmax = _mgx11c->xmax; _mgx11c->oymax = _mgx11c->ymax;
  _mgx11c->xmin = _mgx11c->ymin = INT_MAX;
  _mgx11c->xmax = _mgx11c->ymax = INT_MIN;
}

/*
   Function: Xmg_add
   Description: add a primitive (polygon, vertex, line) to the display list
   Author: Daeron Meyer
*/
void Xmg_add(int primtype, int numdata, void *data, void *cdata)
{
  HPoint3 *vt = (HPoint3 *)data;
  float *col = (float *)cdata;
  ColorA *colarray = (ColorA *)cdata;
  CPoint3 *vts;
  int i;
  static mgx11prim *prim;
  static int *primp;
  static int color[3], ecolor[3];
  static int numverts;
  static float average_depth;
  
  switch (primtype)
  {
	case MGX_BGNLINE:
	case MGX_BGNSLINE:
	  average_depth = 0.0;
          prim =
	    &(VVEC(_mgx11c->mysort->prims, mgx11prim)[_mgx11c->mysort->cprim]);
          primp =
	    &(VVEC(_mgx11c->mysort->primsort, int)[_mgx11c->mysort->cprim]);

          if (primtype == MGX_BGNLINE)
	    prim->mykind = PRIM_LINE;
	  else
	    prim->mykind = PRIM_SLINE;

	  prim->index = _mgx11c->mysort->cvert;
	  prim->depth = -100000; /* very far behind the viewer */
	  numverts = 0;

 	  prim->ecolor[0] = ecolor[0];
	  prim->ecolor[1] = ecolor[1];
 	  prim->ecolor[2] = ecolor[2];
	  prim->ewidth = curwidth;

          VVEC(_mgx11c->mysort->primsort, int)[_mgx11c->mysort->cprim] =
		_mgx11c->mysort->cprim;

	  if (!(_mgc->has & HAS_S2O))
	    mg_findS2O();
	  mg_findO2S();
	  break;

	case MGX_BGNPOLY:
	case MGX_BGNSPOLY:
	case MGX_BGNEPOLY:
	case MGX_BGNSEPOLY:
	  average_depth = 0.0;
	  /*fprintf(stderr,"Begin drawing polygon\n");*/
          prim = &(VVEC(_mgx11c->mysort->prims, mgx11prim)[_mgx11c->mysort->cprim]);
          if (primtype == MGX_BGNPOLY)
	    prim->mykind = PRIM_POLYGON;
	  else if (primtype == MGX_BGNSPOLY)
	    prim->mykind = PRIM_SPOLYGON;
	  else if (primtype == MGX_BGNEPOLY)
	    prim->mykind = PRIM_EPOLYGON;
	  else
	    prim->mykind = PRIM_SEPOLYGON;

	  prim->ewidth = curwidth;
	  prim->index = _mgx11c->mysort->cvert;
	  prim->depth = -100000; /* very far behind the viewer */
	  numverts = 0;
	  
          VVEC(_mgx11c->mysort->primsort, int)[_mgx11c->mysort->cprim] =
		_mgx11c->mysort->cprim;

	  if (!(_mgc->has & HAS_S2O))
	    mg_findS2O();
	  mg_findO2S();
	  break;

	case MGX_VERTEX:
	  for (i=0; i<numdata; i++)
	  {
            vts = &(VVEC(_mgx11c->mysort->pverts, CPoint3)[_mgx11c->mysort->cvert]);
	    if (HPt3TransPt3(_mgc->O2S, &(vt[i]), (Point3 *) vts) < 0)
	      prim->mykind = PRIM_INVIS; /* partially behind clipping
						plane */
	    if ((prim->mykind != PRIM_INVIS) && !(_mgx11c->exposed))
	    {
		if (vts->x < _mgx11c->xmin)
		    _mgx11c->xmin = vts->x;
		if (vts->y < _mgx11c->ymin)
		    _mgx11c->ymin = vts->y;
		if (vts->x > _mgx11c->xmax)
		    _mgx11c->xmax = vts->x;
		if (vts->y > _mgx11c->ymax)
		    _mgx11c->ymax = vts->y;
	    }
		
	    vts->z += _mgx11c->znudgeby;
	    vts->vcol = black;
/*
	    fprintf(stderr,"vertex %f %f %f - %f %f %f\n",vt[i].x, vt[i].y,
		vt[i].z, vts->x, vts->y, vts->z);
*/
	    _mgx11c->mysort->cvert++;
	    numverts++;
	    if (_mgx11c->mysort->cvert > _mgx11c->mysort->pvertnum)
	    {
	       _mgx11c->mysort->pvertnum*=2;
	       vvneeds(&(_mgx11c->mysort->pverts), _mgx11c->mysort->pvertnum);
	    }

	    if (vts->z > prim->depth)
	    {
	      prim->depth = vts->z;
	    }

	  average_depth += vts->z;

	  }
	  break;

	case MGX_CVERTEX:
	  for (i=0; i<numdata; i++)
	  {
            vts = &(VVEC(_mgx11c->mysort->pverts, CPoint3)[_mgx11c->mysort->cvert]);
	    if (HPt3TransPt3(_mgc->O2S, &(vt[i]), (Point3 *) vts) < 0)
	      prim->mykind = PRIM_INVIS; /* partially behind clipping
						plane */
	    if (prim->mykind != PRIM_INVIS)
	    {
		if (vts->x < _mgx11c->xmin)
		    _mgx11c->xmin = vts->x;
		if (vts->y < _mgx11c->ymin)
		    _mgx11c->ymin = vts->y;
		if (vts->x > _mgx11c->xmax)
		    _mgx11c->xmax = vts->x;
		if (vts->y > _mgx11c->ymax)
		    _mgx11c->ymax = vts->y;
	    }
		
	    vts->z += _mgx11c->znudgeby;
	    vts->vcol = colarray[i];

	    _mgx11c->mysort->cvert++;
	    numverts++;
	    if (_mgx11c->mysort->cvert > _mgx11c->mysort->pvertnum)
	    {
	       _mgx11c->mysort->pvertnum*=2;
	       vvneeds(&(_mgx11c->mysort->pverts), _mgx11c->mysort->pvertnum);
	    }

	    if (vts->z > prim->depth)
	    {
	      prim->depth = vts->z;
	    }

	  average_depth += vts->z;

	  }
	  break;



	case MGX_COLOR:
 	  color[0] = (int)(255.0 * col[0]);
 	  color[1] = (int)(255.0 * col[1]);
 	  color[2] = (int)(255.0 * col[2]);
	  break;

	case MGX_ECOLOR:
 	  ecolor[0] = (int)(255.0 * col[0]);
 	  ecolor[1] = (int)(255.0 * col[1]);
 	  ecolor[2] = (int)(255.0 * col[2]);
	  break;

	case MGX_END:
	  prim->numvts = numverts;
	  if (numverts > _mgx11c->mysort->maxverts)
	    _mgx11c->mysort->maxverts = numverts;
          average_depth += prim->depth;
          average_depth /= (float)(numverts+1);
	  prim->depth = average_depth;

 	  prim->color[0] = color[0];
 	  prim->color[1] = color[1];
 	  prim->color[2] = color[2];

 	  prim->ecolor[0] = ecolor[0];
 	  prim->ecolor[1] = ecolor[1];
 	  prim->ecolor[2] = ecolor[2];

	  _mgx11c->mysort->cprim++;
	  if (_mgx11c->mysort->cprim > _mgx11c->mysort->primnum)
	  {
	    _mgx11c->mysort->primnum*=2;
	    vvneeds(&(_mgx11c->mysort->prims), _mgx11c->mysort->primnum);
	    vvneeds(&(_mgx11c->mysort->primsort), _mgx11c->mysort->primnum);
	  }
	  break;

	default:
	  fprintf(stderr,"unknown type of primitive.\n");
	  break;
  }
}

/*
   Function: Xmg_primcomp
   Description: Depth sort by comparing two primitives in a call from qsort()
		(painters algorithm, no subdiv of polygons)
   Author: Daeron Meyer
*/
int Xmg_primcomp(const void *a, const void *b)
{
  mgx11prim *prim =
	VVEC(_mgx11c->mysort->prims, mgx11prim);

/*  fprintf(stderr,"sort:%f %f\n", (*(mgx11prim **)a)->depth,
		(*(mgx11prim **)b)->depth);*/

  if (prim[*(int*)a].depth < prim[*(int*)b].depth)
    return 1;
  else
    return -1;

}

/*
   Function: Xmg_sortdisplaylist
   Description: Does depth sorting of primitives.
   Author: Daeron Meyer
*/
void Xmg_sortdisplaylist()
{
  static int *primp;

  if (_mgx11c->sortmethod == MG_DEPTH)
  {
      primp = VVEC(_mgx11c->mysort->primsort, int);
      qsort(primp, _mgx11c->mysort->cprim, sizeof(int), &Xmg_primcomp);
/*
      fprintf(stderr,"X11: Sort Display List\n");
*/
  }
}

/*
   Function: Xmg_showdisplaylist
   Description: render display list to display
   Author: Daeron Meyer, Tim Rowley
*/
void Xmg_showdisplaylist()
{
  CPoint3 *vts, *vt;
  int ref, i, vloc, *primp;
  mgx11prim *prim, *prim2;
  Display *dpy = _mgx11c->mgx11display;
  mgx11win *curr = _mgx11c->myxwin;
  Drawable win = _mgx11c->myxwin->window;
  unsigned char *buf = _mgx11c->myxwin->buf;
  float *zbuf = mgx11zbuffer;
  int w = _mgx11c->myxwin->width;
  int h = _mgx11c->myxwin->height;
  int zwidth = _mgx11c->myxwin->zwidth;
  GC gc = _mgx11c->myxwin->gc;
  static int width;
  static int height;
  static unsigned long bgcolor;
  void (*poly)(unsigned char *, float *, int, int, int, CPoint3 *, int, int *);
  void (*line)(unsigned char *, float *, int, int, int, 
	       int, int, float, int, int, float, int, int *);
  void (*polyline)(unsigned char *, float *, int, int, int, CPoint3 *, 
		   int, int, int *);
  void (*spolyline)(unsigned char *, float *, int, int, int, CPoint3 *, 
		    int, int, int *);
  void (*spoly)(unsigned char *, float *, int, int, int, CPoint3 *, 
		int, int *);
  void (*clear)(unsigned char *, float *, int, int, int, int *, int,
		int, int, int, int, int);
  int color[3];
  int xmin, ymin, xmax, ymax;
  int maxlinewidth = 0;
  int wantedzsize;

  /* Choose functions */

  if (_mgx11c->bitdepth == 8)
  {
      clear = Xmgr_8clear;
      if (_mgx11c->sortmethod == MG_ZBUFFER)
      {
	  if (_mgx11c->dither)
	  {
	      poly = Xmgr_8DZpoly;
	      line = Xmgr_8DZline;
	      polyline = Xmgr_8DZpolyline;
	      spolyline = Xmgr_8DGZpolyline;
	      spoly = Xmgr_8DGZpoly;
	  }
	  else
	  {
	      poly = Xmgr_8Zpoly;
	      line = Xmgr_8Zline;
	      spolyline = polyline = Xmgr_8Zpolyline;
	      spoly = Xmgr_8Zpoly;
	  }
      }
      else
      {
	  if (_mgx11c->dither)
	  {
	      poly = Xmgr_8Dpoly;
	      line = Xmgr_8Dline;
	      polyline = Xmgr_8Dpolyline;
	      spolyline = Xmgr_8DGpolyline;
	      spoly = Xmgr_8DGpoly;
	  }
	  else
	  {
	      poly = Xmgr_8poly;
	      line = Xmgr_8line;
	      spolyline = polyline = Xmgr_8polyline;
	      spoly = Xmgr_8poly;
	  }
      }
  }
  else if (_mgx11c->bitdepth == 24)
  {
      Xmgr_24init(_mgx11c->visual->red_mask,
		_mgx11c->visual->green_mask,
		_mgx11c->visual->blue_mask);
      clear = Xmgr_24clear;
      if (_mgx11c->sortmethod == MG_ZBUFFER)
      {
	  poly = Xmgr_24Zpoly;
	  line = Xmgr_24Zline;
	  polyline = Xmgr_24Zpolyline;
	  spolyline = Xmgr_24GZpolyline;
	  spoly = Xmgr_24GZpoly;
      }
      else
      {
	  poly = Xmgr_24poly;
	  line = Xmgr_24line;
	  polyline = Xmgr_24polyline;
	  spolyline = Xmgr_24Gpolyline;
	  spoly = Xmgr_24Gpoly;
      }
  }
  else if (_mgx11c->bitdepth == 1)
  {
      Xmgr_1init(BlackPixel(dpy, DefaultScreen(dpy)));
      clear = Xmgr_1clear;
      if (_mgx11c->sortmethod == MG_ZBUFFER)
      {
	  poly = Xmgr_1DZpoly;
	  line = Xmgr_1DZline;
	  polyline = Xmgr_1DZpolyline;
	  spolyline = Xmgr_1DGZpolyline;
	  spoly = Xmgr_1DGZpoly;
      }
      else
      {
	  poly = Xmgr_1Dpoly;
	  line = Xmgr_1Dline;
	  polyline = Xmgr_1Dpolyline;
	  spolyline = Xmgr_1DGpolyline;
	  spoly = Xmgr_1DGpoly;
      }
  }
  else
  {
      fprintf(stderr, "X11(Function Select): Unsupported bit depth %d\n", 
	      _mgx11c->bitdepth);
      return;
  }
  
  if (_mgx11c->sortmethod == MG_ZBUFFER)
  {
      switch (_mgx11c->bitdepth)
      {
      case 24:
	  wantedzsize = zwidth*h;
	  break;
      case 8:
	  wantedzsize = w*h;
	  break;
      case 1:
	  wantedzsize = zwidth*h;
	  break;
      default:
	  fprintf(stderr, "X11(Z-buffer allocate): Unsupported bit depth %d\n",
		  _mgx11c->bitdepth);
	  return;
	  break;
      }

      if (wantedzsize > mgx11zsize)
      {
	  if (!mgx11zbuffer)
		zbuf = mgx11zbuffer = (float *)malloc(sizeof(float)*wantedzsize);
	  else
	  	zbuf = mgx11zbuffer = (float *)realloc((void *)mgx11zbuffer, 
						 sizeof(float)*wantedzsize);
	  mgx11zsize = wantedzsize;
      }
  }

  WnGet(_mgc->win, WN_XSIZE, &width);
  WnGet(_mgc->win, WN_YSIZE, &height);

  /* Get dirty rectangle */

  if (_mgx11c->xmin < _mgx11c->oxmin)
      xmin = MIN(width-1,MAX(_mgx11c->xmin,0));
  else
      xmin = MIN(width-1,MAX(_mgx11c->oxmin,0));
  if (_mgx11c->ymin < _mgx11c->oymin)
      ymin = MIN(height-1,MAX(_mgx11c->ymin,0));
  else
      ymin = MIN(height-1,MAX(_mgx11c->oymin,0));
  if (_mgx11c->xmax > _mgx11c->oxmax)
      xmax = MAX(0,MIN(_mgx11c->xmax,width-1));
  else
      xmax = MAX(0,MIN(_mgx11c->oxmax,width-1));
  if (_mgx11c->ymax > _mgx11c->oymax)
      ymax = MAX(0,MIN(_mgx11c->ymax,height-1));
  else
      ymax = MAX(0,MIN(_mgx11c->oymax,height-1));

  if (_mgx11c->exposed)
  {
      _mgx11c->xmin = _mgx11c->ymin = xmin = ymin = 0;
      _mgx11c->xmax = xmax = width-1;
      _mgx11c->ymax = ymax = height-1;
      _mgx11c->exposed = 0;
  }
  if ((_mgc->opts & MGO_INHIBITSWAP) || _mgx11c->noclear)
  {
      _mgx11c->xmin = _mgx11c->ymin = xmin = ymin = 0;
      _mgx11c->xmax = xmax = width-1;
      _mgx11c->ymax = ymax = height-1;
  }
  color[0] = _mgc->background.r*255.0;
  color[1] = _mgc->background.g*255.0;
  color[2] = _mgc->background.b*255.0;

  if (!_mgx11c->noclear)
      clear(buf, zbuf, zwidth, w, h, color, (_mgx11c->sortmethod==MG_ZBUFFER),
        	0, xmin, ymin, xmax, ymax);
  else
      _mgx11c->noclear = 0;

/*  fprintf(stderr,"X11: Show Display List\n"); */

  primp = VVEC(_mgx11c->mysort->primsort, int);
  prim2 = VVEC(_mgx11c->mysort->prims, mgx11prim);
  vts = VVEC(_mgx11c->mysort->pverts, CPoint3);

/*  fprintf(stderr,"number of primitives %d\n",_mgx11c->mysort->cprim); */
  for (ref = 0; ref < _mgx11c->mysort->cprim; ref++)
  {
    prim = &(prim2[primp[ref]]);
    switch (prim->mykind)
    {
      case PRIM_POLYGON:
	  poly(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
	       prim->color);
	  break;

      case PRIM_SPOLYGON:
	  spoly(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
		prim->color);
	  break;

      case PRIM_EPOLYGON:
	  poly(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
	       prim->color);
	  polyline(buf, zbuf, zwidth, w, h, vts+prim->index,
		   prim->numvts, prim->ewidth, prim->ecolor);
	  line(buf, zbuf, zwidth, w, h, vts[prim->index+prim->numvts-1].x,
	       vts[prim->index+prim->numvts-1].y, 
	       vts[prim->index+prim->numvts-1].z, 
	       vts[prim->index].x, vts[prim->index].y, 
	       vts[prim->index].z, prim->ewidth, prim->ecolor);
	  if (prim->ewidth > maxlinewidth)
	      maxlinewidth = prim->ewidth;
	  break;

      case PRIM_SEPOLYGON:
	  spoly(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
		prim->color);
	  polyline(buf, zbuf, zwidth, w, h, vts+prim->index,
		   prim->numvts, prim->ewidth, prim->ecolor);
	  line(buf, zbuf, zwidth, w, h, vts[prim->index+prim->numvts-1].x,
	       vts[prim->index+prim->numvts-1].y, 
	       vts[prim->index+prim->numvts-1].z, 
	       vts[prim->index].x, vts[prim->index].y, 
	       vts[prim->index].z, prim->ewidth, prim->ecolor);
	  if (prim->ewidth > maxlinewidth)
	      maxlinewidth = prim->ewidth;
	  break;

      case PRIM_SLINE:
	  spolyline(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
		    prim->ewidth, prim->ecolor);
	  if (prim->ewidth > maxlinewidth)
	      maxlinewidth = prim->ewidth;
	  break;
      case PRIM_LINE:
	  polyline(buf, zbuf, zwidth, w, h, vts+prim->index, prim->numvts,
		   prim->ewidth, prim->ecolor);
	  if (prim->ewidth > maxlinewidth)
	      maxlinewidth = prim->ewidth;
        break;

      case PRIM_INVIS:
	break;

      default:
        break;
    }
  }

  if (!(_mgc->opts & MGO_INHIBITSWAP)) {
  if (_mgx11c->shm)
  {
      XShmPutImage(dpy, win, gc, _mgx11c->myxwin->image,
		   xmin, ymin, xmin, ymin,
		   xmax-xmin+1, ymax-ymin+1, False);
  }
  else
  {
      XPutImage(dpy, win, gc, _mgx11c->myxwin->image, xmin, ymin, xmin, ymin,
		xmax-xmin+1, ymax-ymin+1);
  }
  } else {
      _mgx11c->noclear = 1;
  }
  Xmg_flush();
  _mgx11c->xmax += maxlinewidth;
  _mgx11c->xmin -= maxlinewidth;
  _mgx11c->ymax += maxlinewidth;
  _mgx11c->ymin -= maxlinewidth;
}

/*
   Function: Xmg_getwinsize
   Description: get the new size of the window and reorganize shared memory
   Author: Daeron Meyer, Tim Rowley
*/
void Xmg_getwinsize(int *xsize, int *ysize, int *xorig, int *yorig)
{
  Display *dpy = _mgx11c->mgx11display;
  Window dpyroot;
  Window Toss;
  Drawable win = _mgx11c->myxwin->window;
  unsigned int width, height, border_width, depth;
  int xpos, ypos, xold, yold;
  int bytes_per_line;
  mgx11win *current=_mgx11c->myxwin;
  XErrorHandler handler;
  int bitmap_pad;

/*  fprintf(stderr,"X11: Get Window Size\n"); */
  if (_mgx11c->visible)
  {
    XGetGeometry(dpy, win, &dpyroot, &xpos, &ypos, &width,
		&height, &border_width, &depth);
    *xsize = width;
    *ysize = height;

    if (_mgx11c->pix)
    {
	*xorig = 0; *yorig = 0;
    }
    else if (XTranslateCoordinates(dpy, win, dpyroot, 0, height-1,
				   &xpos, &ypos, &Toss))
    {
	*xorig=xpos; *yorig=HeightOfScreen(DefaultScreenOfDisplay(dpy)) - ypos;
    }
    else
    {
        *xorig = 0; *yorig = 0;
    }
  }
  else
  {
      *xsize = 0; *ysize = 0;
  }
  WnGet(_mgc->win, WN_XSIZE, &xold);
  WnGet(_mgc->win, WN_YSIZE, &yold);
  if (_mgx11c->bitdepth == 0)
	return;
  if ((xold != width) || (yold != height) || (_mgx11c->myxwin->image == NULL))
  {
    if (_mgx11c->myxwin->image != NULL)
    {
	if (_mgx11c->shm)
	{
/*	    fprintf(stderr, "X11: Destroyed shm\n"); */
	    XShmDetach(dpy, &(_mgx11c->myxwin->shminf));
	    shmdt(_mgx11c->myxwin->shminf.shmaddr);
	}
	XDestroyImage(_mgx11c->myxwin->image);
    }

    current->image = NULL;
    if (XShmQueryExtension(_mgx11c->mgx11display) == True)
    {
	current->image = 
	    XShmCreateImage(_mgx11c->mgx11display, _mgx11c->visual, 
			    _mgx11c->bitdepth,
			    ZPixmap, NULL, &(current->shminf), width, height);
	bytes_per_line = current->image->bytes_per_line;
    }

    _mgx11c->shm = 0;
    if (current->image != NULL)
    {
	_mgx11c->shm = 1;
/*
	fprintf(stderr, "X11: shm creating image with depth = %d visual = %p bit_pre_pixel=%d\n",
		_mgx11c->bitdepth, _mgx11c->visual, current->image->bits_per_pixel);
*/
	current->shminf.shmid = 
	    shmget(IPC_PRIVATE, bytes_per_line * height, IPC_CREAT|0777);
	current->buf =
	    shmat(current->shminf.shmid, NULL, 0);
	current->shminf.shmaddr = current->image->data = (char *) current->buf;
	current->shminf.readOnly = True;
	globalXError = 0;
        handler = XSetErrorHandler(myXErrorHandler);
	XShmAttach(_mgx11c->mgx11display, &(current->shminf));
	XSync(_mgx11c->mgx11display, False);
	shmctl(current->shminf.shmid, IPC_RMID, 0);
        if (globalXError == 1)
        {
           _mgx11c->shm = 0;
           shmdt(current->shminf.shmaddr);
        }
    }
    if (_mgx11c->shm == 0)
    {
        if (!shm_message_shown)
        {
          fprintf(stderr, "Shared memory unavailable, using fallback display method.\n");
          shm_message_shown = 1;
        }

      switch (_mgx11c->bitdepth)
      {
	case 1:
	case 8: bitmap_pad = 8; break;
	case 24: bitmap_pad = 32; break;
	default: fprintf(stderr, "Unknown bit depth %d\n", _mgx11c->bitdepth);
      }
	current->image =
	    XCreateImage(_mgx11c->mgx11display, _mgx11c->visual,
			 _mgx11c->bitdepth, ZPixmap, 0, NULL, width, height,
			 bitmap_pad, 0);
	if((bytes_per_line = current->image->bytes_per_line) == 0) {
	    int bpp = _mgx11c->bitdepth == 24 ? 32 : _mgx11c->bitdepth;
	    bytes_per_line = ((bpp * width + 31) >> 5) << 2;
	}
        current->buf = 
  	    (unsigned char *) malloc(bytes_per_line * height);
	current->image->data = (char *)current->buf;
    }
	
    current->width = bytes_per_line;
    current->height = height;
    _mgx11c->myxwin->zwidth = width;
    _mgx11c->exposed = 1;
  }
}

/*
   Function: mgx11_nearestRGB
   Description: dither RGB pixel at x,y to color index from our colormap
   Author: Daeron Meyer
*/
unsigned long mgx11_nearestRGB(int x, int y, int *rgb)
{
   if (!colorlevels) /* handle TrueColor case */
    return (unsigned long)0;

   return dithergb(x, y, rgb, colorlevels);
}

/*
   Function: mgx11_RGB
   Description: get index of color nearest to RGB value, in colormap
   Author: Daeron Meyer
*/
unsigned long mgx11_RGB(int r, int g, int b)
{
   int col[3];

   if (!colorlevels) /* handle TrueColor case */
    return (unsigned long)0;

   col[0] = r; col[1] = g; col[2] = b;
   return dithergb(0, 0, col, colorlevels);
}

/*
   Function: mgx11_setRGB
   Description: use reserved colorcell for smooth dynamic color changing.
			For instance, this function is relied on by the
			Color Panel in Geomview.
   Author: Daeron Meyer
*/
unsigned long mgx11_setRGB(int r, int g, int b)
{
  int cell = colorlevels * colorlevels * colorlevels;

  if (!colorlevels) /* handle TrueColor case */
    return (unsigned long)0;

  mgx11colorcells[cell].red = (unsigned short)(r * 256);
  mgx11colorcells[cell].green = (unsigned short)(g * 256);
  mgx11colorcells[cell].blue = (unsigned short)(b * 256);
  mgx11colorcells[cell].flags = DoRed | DoGreen | DoBlue;
  XStoreColor(mgx11display, cmap, &(mgx11colorcells[cell]));

  return mgx11colors[cell];
}

/*
   Function: mgx11_linewidth
   Description: set current linewidth
   Author: Daeron Meyer
*/
void mgx11_linewidth(short width)
{
  curwidth = (int) width;
}
