/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mgP.h"
#include "mgx11P.h"
#include "mgx11shade.h"

extern void mgx11_linewidth(short);

mgx11_appearance( struct mgastk *ma, int mask )
{
  Appearance *ap = &(ma->ap);

  if (mask & APF_LINEWIDTH) {
    mgx11_linewidth(ap->linewidth);
    _mgc->has &= ~HAS_POINT;
  }

  if (mask & APF_SHADING) {
/*
    if (ap->shading == APF_SMOOTH)
      ap->shading = APF_FLAT;
  bye bye to kludge in non-gouraud shading mgx11
*/
    if(!IS_SHADED(ap->shading) || ma->shader != NULL) {
	/* Use software shader if one exists and user wants lighting */
	ma->useshader = (ma->shader != NULL) && IS_SHADED(ap->shading);
    }
    else {
	/* No software shading, just use raw colors */
	ma->useshader = 0;
    }
  }

}

void
mgx11_setshader(mgshadefunc shader)
{
    register struct mgastk *ma = _mgc->astk;
    int wasusing = ma->useshader;

    ma->shader = shader;
    ma->useshader = (shader != NULL && IS_SHADED(ma->ap.shading)) ? 1 : 0;
    if(ma->useshader != wasusing)
	mgx11_appearance(_mgc->astk, APF_SHADING);
}
