/* Copyright (c) 1994 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Author: Timothy Rowley */

#ifndef MGX11RENDER
#define MGX11RENDER

typedef struct
{
    int init;
    int P1x, P1r, P1g, P1b, P2x, P2r, P2g, P2b;
    double P1z, P2z;
} endPoint;

#define ABS(a) (((a)<0) ? -(a) : (a))
#define SGN(a) (((a)<0) ? -1 : 1)

#ifdef MAX
#undef MAX
#endif
#define MAX(a,b) (((a)<(b)) ? b : a)

#ifdef MIN
#undef MIN
#endif
#define MIN(a,b) (((a)<(b)) ? a : b)

void
Xmgr_gradWrapper(unsigned char *buf, float *zbuf, int zwidth, int width,
	int height, CPoint3 *p0, CPoint3 *p1, int lwidth,
	void (*flat)(unsigned char *, float *, int, int, int, int, int, float,
			int, int, float, int, int *),
	void (*smooth)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int));

void
Xmgr_polyscan(unsigned char *buf, float *zbuf, int zwidth, 
	      int width, int height, CPoint3 *p, int n, int *color,
	      endPoint *mug,
	      void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *));

void
Xmgr_Zpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
	       int width, int height, CPoint3 *p, int n, int *color,
	       endPoint *mug,
	       void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *));

void
Xmgr_Graypolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		  int width, int height, CPoint3 *p, int n,
		  endPoint *mug,
		  void (*scanfunc)(unsigned char *, float *, int, int, int, 
				   int, int, endPoint *));


void
Xmgr_GrayZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		   int width, int height, CPoint3 *p, int n,
		   endPoint *mug,
		   void (*scanfunc)(unsigned char *, float *, int, int, int, 
				    int, int, endPoint *));

void
Xmgr_Gpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
	       int width, int height, CPoint3 *p, int n,
	       endPoint *mug,
	       void (*scanfunc)(unsigned char *, float *, int, int, int, 
				int, int, endPoint *));

void
Xmgr_GZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		int width, int height, CPoint3 *p, int n,
		endPoint *mug,
		void (*scanfunc)(unsigned char *, float *, int, int, int,
				 int, int, endPoint *));

#endif

