/* Copyright (c) 1994 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Author: Timothy Rowley */

#include <limits.h>
#include "mgP.h"
#include "mgx11P.h"

void
Xmgr_gradWrapper(unsigned char *buf, float *zbuf, int zwidth, int width,
	int height, CPoint3 *p0, CPoint3 *p1, int lwidth,
	void (*flat)(unsigned char *, float *, int, int, int, int, int, float,
			int, int, float, int, int *),
	void (*smooth)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int))
{
    int color[3];
    
    if ((p0->vcol.r == p1->vcol.r) && (p0->vcol.g == p1->vcol.g) &&
	(p0->vcol.b == p1->vcol.b))
    {
	color[0] = 255*p0->vcol.r;
	color[1] = 255*p0->vcol.g;
	color[2] = 255*p0->vcol.b;
	flat(buf, zbuf, zwidth, width, height, p0->x, p0->y, p0->z,
	     p1->x, p1->y, p1->z, lwidth, color);
    }
    else
	smooth(buf, zbuf, zwidth, width, height, p0, p1, lwidth);
}


void
Xmgr_polyscan(unsigned char *buf, float *zbuf, int zwidth, 
	      int width, int height, CPoint3 *p, int n, int *color,
	      endPoint *mug,
	      void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y;
	x2 = p[j].x; y2 = p[j].y;
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	}
	dx = x2-x1;
	dy = y2-y1;
	
	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;
	
	sx = SGN(dx);
	
	x = x1;
	y = y1;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			    mug[y].P1x = x;
			else if (x > mug[y].P2x)
			    mug[y].P2x = x;
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    d -= ax;
		}
		x += sx;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			    mug[y].P1x = x;
			else if (x > mug[y].P2x)
			    mug[y].P2x = x;
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    d -= ay;
		}
		y++;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny),
	     MIN(height-1,maxy), color, mug);
}

void
Xmgr_Zpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
	       int width, int height, CPoint3 *p, int n, int *color,
	       endPoint *mug,
	       void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    double z, z1, z2, delta;             /* z-buffer stuff   */
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y; z1 = p[i].z;
	x2 = p[j].x; y2 = p[j].y; z2 = p[j].z;
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	    z = z2; z2=z1; z1=z;
	}
	dx = x2-x1;
	dy = y2-y1;
	
	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;
	
	sx = SGN(dx);
	
	x = x1;
	y = y1;
	z = z1;
	delta = ABS(dx) + ABS(dy);
	delta = delta ? (z2-z1)/delta : 0;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    z += delta;
		    d -= ax;
		}
		x += sx;
		z += delta;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    z += delta;
		    d -= ay;
		}
		y++;
		z += delta;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny), 
	     MIN(height-1,maxy), color, mug);
}

void
Xmgr_Graypolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		  int width, int height, CPoint3 *p, int n,
		  endPoint *mug,
		  void (*scanfunc)(unsigned char *, float *, int, int, int, 
				   int, int, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    double r, dr;
    int total, r1, r2;
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y;
	r1 = 64*(0.299*p[i].vcol.r + 0.587*p[i].vcol.g + 0.114*p[i].vcol.b);
	x2 = p[j].x; y2 = p[j].y;
	r2 = 64*(0.299*p[j].vcol.r + 0.587*p[j].vcol.g + 0.114*p[j].vcol.b);
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	    d = r2; r2=r1; r1=d;
	}
	dx = x2-x1;
	dy = y2-y1;
	dr = r2-r1;

	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;

	sx = SGN(dx);
	
	x = x1;
	y = y1;
	r = r1;
	total = ABS(dx)+ABS(dy);
	dr = total ? (r2-r1)/(double)total : 0;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x;
			    mug[y].P1r = r;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x;
			    mug[y].P2r = r;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1r = r;
			mug[y].P2r = r;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    r += dr;
		    d -= ax;
		}
		x += sx;
		r += dr;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x;
			    mug[y].P1r = r;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x;
			    mug[y].P2r = r;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1r = r;
			mug[y].P2r = r;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    r += dr;
		    d -= ay;
		}
		y++;
		r += dr;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny), 
	     MIN(height-1,maxy), mug);
}

void
Xmgr_GrayZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		   int width, int height, CPoint3 *p, int n,
		   endPoint *mug,
		   void (*scanfunc)(unsigned char *, float *, int, int, int, 
				    int, int, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    double z, z1, z2, delta;             /* z-buffer stuff   */
    double r, dr;
    int total, r1, r2;
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y; z1 = p[i].z; 
	r1 = 64*(0.299*p[i].vcol.r + 0.587*p[i].vcol.g + 0.114*p[i].vcol.b);
	x2 = p[j].x; y2 = p[j].y; z2 = p[j].z;
	r2 = 64*(0.299*p[j].vcol.r + 0.587*p[j].vcol.g + 0.114*p[j].vcol.b);
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	    d = r2; r2=r1; r1=d;
	    z = z2; z2=z1; z1=z;
	}
	dx = x2-x1;
	dy = y2-y1;
	dr = r2-r1;

	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;

	sx = SGN(dx);
	
	x = x1;
	y = y1;
	r = r1;
	z = z1;
	total = ABS(dx)+ABS(dy);
	if (total)
	{
	    delta = (z2-z1)/total;
	    dr = (r2-r1)/(double)total;
	}
	else
	    delta = dr = 0;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			    mug[y].P1r = r;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			    mug[y].P2r = r;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
			mug[y].P1r = r;
			mug[y].P2r = r;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    z += delta;
		    r += dr;
		    d -= ax;
		}
		x += sx;
		z += delta;
		r += dr;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			    mug[y].P1r = r;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			    mug[y].P2r = r;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
			mug[y].P1r = r;
			mug[y].P2r = r;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    z += delta;
		    r += dr;
		    d -= ay;
		}
		y++;
		z += delta;
		r += dr;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny), 
	     MIN(height-1,maxy), mug);
}

void
Xmgr_Gpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		int width, int height, CPoint3 *p, int n, endPoint *mug,
		void (*scanfunc)(unsigned char *, float *, int, int, int, 
				 int, int, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    double r, g, b, dr, dg, db;
    int total, r1, r2, g1, g2, b1, b2;
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y;
	r1 = 255*p[i].vcol.r; g1 = 255*p[i].vcol.g; b1 = 255*p[i].vcol.b;
	x2 = p[j].x; y2 = p[j].y;
	r2 = 255*p[j].vcol.r; g2 = 255*p[j].vcol.g; b2 = 255*p[j].vcol.b;
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	    d = r2; r2=r1; r1=d;
	    d = g2; g2=g1; g1=d;
	    d = b2; b2=b1; b1=d;
	}
	dx = x2-x1;
	dy = y2-y1;
	dr = r2-r1;
	dg = g2-g1;
	db = b2-b1;

	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;

	sx = SGN(dx);
	
	x = x1;
	y = y1;
	r = r1;
	g = g1;
	b = b1;
	total = ABS(dx)+ABS(dy);
	if (total)
	{
	    dr = (r2-r1)/(double)total;
	    dg = (g2-g1)/(double)total;
	    db = (b2-b1)/(double)total;
	}
	else
	    dr = dg = db = 0;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x;
			    mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x;
			    mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    r += dr; g += dg; b += db;
		    d -= ax;
		}
		x += sx;
		r += dr; g += dg; b += db;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x;
			    mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x;
			    mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    r += dr; g += dg; b += db;
		    d -= ay;
		}
		y++;
		r += dr; g += dg; b += db;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny), 
	     MIN(height-1,maxy), mug);
}

void
Xmgr_GZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		int width, int height, CPoint3 *p, int n, endPoint *mug,
		void (*scanfunc)(unsigned char *, float *, int, int, int, 
				 int, int, endPoint *))
{
    int x,y,dx,dy,d;                         /* bresenham engine */
    int sx, ax, ay;                         /* ...              */
    int miny = INT_MAX, maxy = INT_MIN;    /* y-bounds         */
    int i,j,x1,x2,y1,y2;                  /* indices          */
    double z, z1, z2, delta;             /* z-buffer stuff   */
    double r, g, b, dr, dg, db;
    int total, r1, r2, g1, g2, b1, b2;
    
    for (i=0; i<n; i++)
    {
	miny = MIN(p[i].y, miny);
	maxy = MAX(p[i].y, maxy);
    }
    for (i=MAX(0,miny); i<=MIN(height-1,maxy); i++)
	mug[i].init = 0;

    for (i=0; i<n; i++)
    {
	if ((j = i+1)==n)
	    j=0;
	x1 = p[i].x; y1 = p[i].y; z1 = p[i].z; 
	r1 = 255*p[i].vcol.r; g1 = 255*p[i].vcol.g; b1 = 255*p[i].vcol.b;
	x2 = p[j].x; y2 = p[j].y; z2 = p[j].z;
	r2 = 255*p[j].vcol.r; g2 = 255*p[j].vcol.g; b2 = 255*p[j].vcol.b;
	if (y2<y1)
	{
	    d = y2; y2=y1; y1=d;
	    d = x2; x2=x1; x1=d;
	    d = r2; r2=r1; r1=d;
	    d = g2; g2=g1; g1=d;
	    d = b2; b2=b1; b1=d;
	    z = z2; z2=z1; z1=z;
	}
	dx = x2-x1;
	dy = y2-y1;
	dr = r2-r1;
	dg = g2-g1;
	db = b2-b1;

	ax = ABS(dx)<<1;
	ay = ABS(dy)<<1;

	sx = SGN(dx);
	
	x = x1;
	y = y1;
	r = r1;
	g = g1;
	b = b1;
	z = z1;
	total = ABS(dx)+ABS(dy);
	if (total)
	{
	    delta = (z2-z1)/total;
	    dr = (r2-r1)/(double)total;
	    dg = (g2-g1)/(double)total;
	    db = (b2-b1)/(double)total;
	}
	else
	    delta = dr = dg = db = 0;
	if (ax>ay)
	{		/* x dominant */
	    d = ay-(ax>>1);
	    for (;;)
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			    mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			    mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
			mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
		    }
		if (x==x2) break;
		if (d>=0)
		{
		    y++;
		    z += delta;
		    r += dr; g += dg; b += db;
		    d -= ax;
		}
		x += sx;
		z += delta;
		r += dr; g += dg; b += db;
		d += ay;
	    }
	}
	else 
	{			/* y dominant */
	    d = ax-(ay>>1);
	    for (;;) 
	    {
		if (y>=height) break;
		if (y>=0)
		    if(mug[y].init)
		    {
			if (x < mug[y].P1x)
			{
			    mug[y].P1x = x; mug[y].P1z = z;
			    mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			}
			else if (x > mug[y].P2x)
			{
			    mug[y].P2x = x; mug[y].P2z = z;
			    mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
			}
		    }
		    else
		    {
			mug[y].init = 1;
			mug[y].P1x = x; mug[y].P2x = x;
			mug[y].P1z = z; mug[y].P2z = z;
			mug[y].P1r = r; mug[y].P1g = g; mug[y].P1b = b;
			mug[y].P2r = r; mug[y].P2g = g; mug[y].P2b = b;
		    }
		if (y==y2) break;
		if (d>=0)
		{
		    x += sx;
		    z += delta;
		    r += dr; g += dg; b += db;
		    d -= ay;
		}
		y++;
		z += delta;
		r += dr; g += dg; b += db;
		d += ax;
	    }
	}
    }
    scanfunc(buf, zbuf, zwidth, width, height, MAX(0,miny), 
	     MIN(height-1,maxy), mug);
}






