/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include "vectP.h"
#include "pickP.h"
#include "appearance.h"

Vect *
VectPick(Vect *v, Pick *p, Appearance *ap, Transform T)
{
  Point3 plist[2], *vectpt;
  int i, j, k;
  int found;
  unsigned int apflag;

  /* Make sure that the edges do not register as visible - otherwise 
   * they could really mess things up */
  if (ap != NULL) {
    apflag = ap->flag;
    ap->flag ^= (ap->flag & APF_EDGEDRAW) ? APF_EDGEDRAW : 0;
  }
    
  found = 0;

  /* Make a copy of the points of the vect and transform everything at
   * once */
  vectpt = OOGLNewNE(Point3, v->nvert, "vectpt array");
  for (i = 0; i < v->nvert; i++) HPt3TransPt3(T, &v->p[i], &vectpt[i]);

  for (i = k = 0; i < v->nvec; i++) {
    for (j = 0; j < abs(v->vnvert[i]) - 1;) {
      plist[0] = vectpt[k + j++];
      plist[1] = vectpt[k + j];
      if (PickFace(2, plist, p, ap)) {
	found = 1;
	p->vi = p->vi ? k + j : k + j - 1;
	p->ei[0] = k + j - 1;
	p->ei[1] = k + j;
      }
    }
    if (v->vnvert[i] < 0) {
      plist[0] = vectpt[k];
      plist[1] = vectpt[k + j];
      if (PickFace(2, plist, p, ap)) {
	found = 1;
	p->vi = p->vi ? k : k + j;
	p->ei[0] = k;
	p->ei[1] = k + j;
      }
    }
    k += j + 1;
  }


  if (vectpt != NULL) OOGLFree(vectpt);

  if (ap != NULL) ap->flag = apflag;

  if (!found) return NULL;

  if (p->found & PW_VERT) 
    HPt3Transform(T, &v->p[p->vi], &p->v);
  else p->vi = -1;
  if (p->found & PW_EDGE) {
    HPt3Transform(T, &v->p[p->ei[0]], &p->e[0]);
    HPt3Transform(T, &v->p[p->ei[1]], &p->e[1]);
  } else p->ei[0] = p->ei[1] = -1;

  /* It really doesn't make sense to claim that we found a face hit...*/
  p->found ^= p->found & PW_FACE;
  p->fi = -1;
  TmCopy(T, p->Tprim);

  return v;
}
