/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/*
 * Geometry Routines
 *
 * Geometry Supercomputer Project
 *
 * ROUTINE DESCRIPTION:  Return the bounding box of a collection of vectors.
 *
 */


#include "skelP.h"


BBox *
SkelBound(s, T)
	register Skel *s;
	Transform T;
{
    register int n;
    Point3 min, max;
    float *p;
    HPoint3 p0;

    n = s->nvert;
    p = s->p;
    if(n <= 0)
	    return NULL;

    if(s->dim == 4 && !(s->geomflags & SKEL_4D)) {
	HPoint3 *hp = (HPoint3 *)p;
	while(--n >= 0 && !finite(p[0] + p[1] + p[2]))
		p += s->dim;
	if(n < 0)
		return NULL;
	HPt3TransPt3(T, (HPoint3 *)p, &min);
	max = min;
	while(--n >= 0) {
		HPt3TransPt3(T, ++hp, &p0);
		if(min.x > p0.x) min.x = p0.x;
		else if(max.x < p0.x) max.x = p0.x;
		if(min.y > p0.y) min.y = p0.y;
		else if(max.y < p0.y) max.y = p0.y;
		if(min.z > p0.z) min.z = p0.z;
		else if(max.z < p0.z) max.z = p0.z;
	} 
	return (BBox *) GeomCreate ("bbox", CR_MIN, &min, CR_MAX, &max, NULL );
    }

    /* Otherwise, it's an N-D skel.  Do what we can. */
#ifdef BBOX_ND_HACK
    return BBox_ND_hack(NULL, p, n*s->dim);
#else
    return NULL;
#endif
}
