/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef	POLYLISTPDEFS
#define	POLYLISTPDEFS
/*
 * Private definitions for PolyList's
 */

#include "bboxP.h"
#include "polylist.h"

#define PLMAGIC GeomMagic ('p', 1)

typedef struct Vertex
{
	HPoint3	pt;
	ColorA	vcol;
	Point3	vn;
}  Vertex;

typedef struct Poly
{
	int	n_vertices;
	Vertex	**v;
	ColorA  pcol;
	Point3	pn;
}  Poly;

struct PolyList
{
	GEOMFIELDS
	int	n_polys;
	int	n_verts;
	Poly	*p;
	Vertex	*vl;
	int	flags;
	int	seq;		/* for 4D->3D tforms */
#  define	  PL_HASVN	0x1	/* Per-vertex normals (vn) valid */
#  define	  PL_HASPN	0x2	/* Per-polygon normals (pn) valid */
#  define	  PL_HASVCOL	0x4	/* Per-vertex colors (vcol) valid */
#  define	  PL_HASPCOL	0x8	/* Per-polygon colors (pcol) valid */
#  define	  PL_EVNORM	0x10	/* Normals are everted */
			/* For 4-D points, see geomflags & VERT_4D */
};


extern PolyList *PolyListCreate(PolyList *exist, GeomClass *Class, va_list a_list);
extern PolyList *PolyListCopy( PolyList *poly );
extern PolyList *PolyListDelete( PolyList *poly );
extern PolyList *PolyListPick( PolyList *, Pick *, Appearance *, Transform );
extern GeomClass *PolyListMethods();

#endif/*POLYLISTPDEFS*/
