/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include <math.h>
#include "ooglutil.h"
#include "polylistP.h"
#include "point3.h"
#include "hpoint3.h"
#include "polyint.h"
#include "pickP.h"
#include "appearance.h"

PolyList *
PolyListPick(PolyList *pl, Pick *p, Appearance *ap, Transform T)
{
  int i;
  vvec plist;
  int fi, vi, found = -1;
  Poly *poly;
  unsigned int apflag;

  /* Make sure that vects do not register as visible - otherwise they
   * will wreck havoc with the edge picking stuff. */
  if (ap != NULL) {
    apflag = ap->flag;
    ap->flag ^= (ap->flag & APF_VECTDRAW) ? APF_VECTDRAW : 0;
  }
  
  VVINIT(plist, Point3, 0);

  found = -1;
  for (fi=0, poly=pl->p; fi<pl->n_polys; ++fi, ++poly) {
    vvneeds(&plist, poly->n_vertices);
    for (vi=0; vi<poly->n_vertices; vi++) 
      HPt3TransPt3(T, &poly->v[vi]->pt, VVINDEX(plist, Point3, vi));
    if (PickFace(poly->n_vertices, VVINDEX(plist, Point3, 0), p, ap)) 
      found = fi;
  }

  vvfree(&plist);

  if (ap != NULL) ap->flag = apflag;

  if (found == -1) return NULL;

  if (p->found & PW_VERT) {
    p->vi = pl->p[found].v[p->vi] - pl->vl;
    HPt3Transform(T, &pl->vl[p->vi].pt, &p->v);
  }
  if (p->found & PW_EDGE) {
    p->ei[0] = pl->p[found].v[p->ei[0]] - pl->vl;
    p->ei[1] = pl->p[found].v[p->ei[1]] - pl->vl;
    HPt3Transform(T, &pl->vl[p->ei[0]].pt, &p->e[0]);
    HPt3Transform(T, &pl->vl[p->ei[1]].pt, &p->e[1]);
  }
  if (p->found & PW_FACE) {
    p->f = OOGLNewNE(HPoint3, p->fn, "PolyList pick");
    for (i = 0; i < p->fn; i++) 
      HPt3Transform(T, &pl->p[found].v[i]->pt, &p->f[i]);
    p->fi = found;
  }

  TmCopy(T, p->Tprim);

  return pl;
}
