/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /usrb/gcg/ngrap/src/lib/gprim/polylist/RCS/pldraw.c,v 1.23 1994/04/15 18:45:07 slevy Exp $ */

/*
 * Draw a PolyList using mg library.
 */

#include "polylistP.h"
#include "appearance.h"
#include "mgP.h"	/* need mgP.h (instead of mg.h) for _mgc below */
#include "cmodel.h"
#include "hpointn.h"
#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

static void
draw_projected_polylist(mgmapfunc NDmap, void *NDinfo, PolyList *pl)
{
    PolyList newpl = *pl;
    HPointN *h;
    Poly *op, *np, *polys;
    Vertex *ov, *nv, *verts;
    Vertex **vps;
    int i, j, colored = 0;
    float *hdata;

    /* Copy the PolyList onto the stack. */
    newpl.vl = (Vertex *)alloca(pl->n_verts * sizeof(Vertex));
    newpl.p = (Poly *)alloca(pl->n_polys * sizeof(Poly));

    for(i = 0, op = pl->p, np = newpl.p; i < pl->n_polys; i++, op++, np++) {
	*np = *op;
	vps = (Vertex **)alloca(np->n_vertices * sizeof(Vertex *));
	np->v = vps;
	for(j = 0; j < np->n_vertices; j++)
	    np->v[j] = newpl.vl + (op->v[j] - pl->vl);
    }

    /* Transform vertices */
    h = HPtNCreate(5, NULL);
    hdata = h->v;
    for(i = 0, ov = pl->vl, nv = newpl.vl; i < pl->n_verts; i++, ov++, nv++) {
	*(HPoint3 *)h->v = ov->pt;
	colored = (*NDmap)(NDinfo, h, &nv->pt, &nv->vcol);
    }

    if(colored)
	newpl.flags = (newpl.flags &~ PL_HASPCOL) | PL_HASVCOL;
    newpl.flags &= ~(PL_HASVN|PL_HASPN);
    PolyListComputeNormals(&newpl);
    mgpolylist(newpl.n_polys, newpl.p, newpl.n_verts, newpl.vl, newpl.flags);
    h->v = hdata;
    HPtNDelete(h);
}

PolyList *
PolyListDraw( register PolyList *pl )
{
    extern int conformal_sphere;
    if (pl == NULL)
      return NULL;
    

    if(_mgc->NDinfo) {
	Transform T;
	float focallen;
	mgpushtransform();
	CamGet(_mgc->cam, CAM_FOCUS, &focallen);
	TmTranslate(T, 0., 0., -focallen);
	TmConcat(T, _mgc->C2W, T);
	mgsettransform(T);

	draw_projected_polylist(_mgc->NDmap, _mgc->NDinfo, pl);

	mgpoptransform();
	return pl;
    }

    /*
     * The drawing routines might need either polygon or vertex normals,
     * so if either is missing and either might be needed,
     * we force it to be computed.
     */
    if((pl->flags & (PL_HASVN|PL_HASPN)) != (PL_HASVN|PL_HASPN)) {
	register Appearance *ap = mggetappearance();
	if((ap->shading != APF_CONSTANT && ap->flag & APF_FACEDRAW)
			|| ap->flag & APF_NORMALDRAW)
	    PolyListComputeNormals(pl, NULL);
    }

    if (_mgc->space & TM_CONFORMAL_BALL) {
	cmodel_clear(_mgc->space);
	cm_read_polylist(pl);
	cmodel_draw(pl->flags);
    } else if(_mgc->astk->useshader) {

	/*
	 * Software shading
	 */
	ColorA *c0 = (ColorA *)&_mgc->astk->mat.diffuse;
	ColorA pc, *nc, *savedc = NULL;
	int i, j;
	int flags = pl->flags;

	if(_mgc->astk->mat.override & MTF_DIFFUSE)
	    flags &= ~(PL_HASVCOL | PL_HASPCOL);

	/* Smooth or facetted? */
	if(_mgc->astk->ap.shading == APF_SMOOTH) {
	    Vertex *v;
	    if(flags & PL_HASVCOL) {
		savedc = (ColorA *)alloca(pl->n_verts * sizeof(ColorA));
	    } else if(flags & PL_HASPCOL) {
		/* Rats.  We need vertex colors, but only face colors are
		 * supplied.  Associate a face with each vertex.
		 */
		Poly *p = pl->p;
		for(i = 0; i < pl->n_polys; i++, p++)
		    for(j = p->n_vertices; --j >= 0; )
			p->v[j]->vcol = p->pcol;
		c0 = &pc;
	    }
	    for(i = 0, nc = savedc, v = pl->vl; i < pl->n_verts; i++, v++) {
		if(savedc) {
			/* If we had per-vertex colors, save & use them */
		    *nc = v->vcol;
		    (*_mgc->astk->shader)(1, &v->pt, &v->vn,
			nc, &v->vcol);
		    nc++;
		} else {
			/* If no per-vertex colors, use material default */
		    if(flags & PL_HASPCOL) pc = v->vcol;
		    (*_mgc->astk->shader)(1, &v->pt, &v->vn, c0, &v->vcol);
		}
	    }
	    mgpolylist(pl->n_polys, pl->p, pl->n_verts, pl->vl,
		flags|PL_HASVCOL);

		/* Restore colors if trashed */
	    if(savedc) {
		for(i = 0, v = pl->vl, nc = savedc; i < pl->n_verts; i++, v++)
		    v->vcol = *nc++;
	    }
	} else /* facetted */ {
	    Poly *p;

	    if(flags & PL_HASPCOL)
		nc = savedc = (ColorA *)alloca(pl->n_polys * sizeof(ColorA));
	    for(i = 0, p = pl->p; i < pl->n_polys; i++, p++) {
		if(savedc) {
		    *nc = p->pcol;
		    (*_mgc->astk->shader)(1, &p->v[0]->pt, &p->pn,
				nc, &p->pcol);
		    nc++;
		} else {
		    (*_mgc->astk->shader)(1, &p->v[0]->pt, &p->pn,
				flags & PL_HASVCOL ? &p->v[0]->vcol : c0,
				&p->pcol);
		}
	    }
	    mgpolylist(pl->n_polys, pl->p, pl->n_verts, pl->vl,
		flags|PL_HASPCOL);

		/* Restore colors if trashed */
	    if(savedc) {
		for(i = 0, p = pl->p, nc = savedc; i < pl->n_polys; i++, p++)
		    p->pcol = *nc++;
	    }
	}
    } else {

	/*
	 * Ordinary shading
	 */
	mgpolylist(pl->n_polys, pl->p, pl->n_verts, pl->vl, pl->flags);
    }
    return pl;

}
