/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /usrb/gcg/ngrap/src/lib/gprim/polylist/RCS/pldraw.c,v 1.23 1994/04/15 18:45:07 slevy Exp $ */

/*
 * Draw a PolyList using mg library.
 */

#include "npolylistP.h"
#include "polylistP.h"	/* Need plain PolyList, too, for mgpolylist() */
#include "appearance.h"
#include "mgP.h"	/* need mgP.h (instead of mg.h) for _mgc below */
#include "hpointn.h"
#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

static void
draw_projected_polylist(mgmapfunc NDmap, void *NDinfo, NPolyList *pl)
{
    PolyList newpl;
    HPointN *h;
    NPoly *op;
    Poly *np;
    Vertex *nv, *verts;
    float *ov;
    ColorA *oc;
    Vertex **vps;
    int i, j, k, colored = 0;
    float *hdata;

    /* Copy the PolyList onto the stack. */
    newpl.n_polys = pl->n_polys;
    newpl.n_verts = pl->n_verts;
    newpl.flags = pl->flags;
    newpl.vl = (Vertex *)alloca(pl->n_verts * sizeof(Vertex));
    newpl.p = (Poly *)alloca(pl->n_polys * sizeof(Poly));

    for(i = 0, op = pl->p, np = newpl.p; i < pl->n_polys; i++, op++, np++) {
	np->n_vertices = op->n_vertices;
	np->v = vps = (Vertex **)alloca(np->n_vertices * sizeof(Vertex *));
	np->pcol = op->pcol;
	for(j = 0, k = op->vi0; j < np->n_vertices; j++, k++)
	    np->v[j] = &newpl.vl[pl->vi[k]];
    }

    /* Transform vertices */
    h = HPtNCreate(pl->pdim, NULL);
    hdata = h->v;
    ov = pl->v;
    oc = pl->vcol;
    for(i = 0, ov = pl->v, nv = newpl.vl; i < pl->n_verts; i++, nv++) {
	h->v = ov;
	colored = (*NDmap)(NDinfo, h, &nv->pt, &nv->vcol);
	ov += pl->pdim;
    }

    if(colored) {
	newpl.flags = (newpl.flags &~ PL_HASPCOL) | PL_HASVCOL;
    } else if((oc = pl->vcol) != NULL) {
	for(i = pl->n_verts, nv = newpl.vl; --i >= 0; nv++)
	    nv->vcol = *oc++;
    }
    newpl.flags &= ~(PL_HASVN|PL_HASPN);
    PolyListComputeNormals(&newpl);
    mgpolylist(newpl.n_polys, newpl.p, newpl.n_verts, newpl.vl, newpl.flags);
    h->v = hdata;
    HPtNDelete(h);
}

NPolyList *
NPolyListDraw( register NPolyList *pl )
{
    static int warned = 0;

    if (pl == NULL)
      return NULL;

    if(_mgc->NDinfo) {
	Transform T;
	float focallen;
	mgpushtransform();
	CamGet(_mgc->cam, CAM_FOCUS, &focallen);
	TmTranslate(T, 0., 0., -focallen);
	TmConcat(T, _mgc->C2W, T);
	mgsettransform(T);

	draw_projected_polylist(_mgc->NDmap, _mgc->NDinfo, pl);

	mgpoptransform();
	return pl;
    }

    if(!warned) {
	OOGLError(0,"Sorry, need to turn on N-D mode before nOFF objects become visible.");
	warned = 1;
    }
    return NULL;
}
