/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /usr8/geom/devel/ngrap/src/lib/gprim/polylist/RCS/plcopy.c,v 1.10 1992/01/31 16:15:23 mbp Exp $ */

/*
 * Geometry object routines
 *
 * Copy an NPolyList.
 */


#include "npolylistP.h"

NPolyList *
NPolyListCopy(NPolyList *p)
{
	NPolyList *newpl;
	NPoly *newp;
	float *newv;
	int *newvi;
	ColorA *newvc;
	register int i, j;

	if(p == NULL) return NULL;

	newv = OOGLNewNE(float, p->pdim*p->n_verts, "NPolyList verts");
	newp = OOGLNewNE(NPoly, p->n_polys, "NPolyList polygons");
	newvc = p->vcol ? OOGLNewNE(ColorA, p->n_verts, "NPolyList vcolors") : NULL;
	newvi = OOGLNewNE(int, p->nvi, "NPolyList vert indices");
	newpl = OOGLNewE(NPolyList, "NPolyList");
	*newpl = *p;
	newpl->p = newp;
	newpl->v = newv;
	newpl->vcol = newvc;
	memcpy(newv, p->v, p->n_verts * p->pdim * sizeof(float));
	memcpy(newp, p->p, p->n_polys * sizeof(NPoly));
	memcpy(newvi, p->vi, p->nvi * sizeof(int));
	if(newvc) memcpy(newvc, p->vcol, p->n_verts * sizeof(ColorA));

	return (newpl);
}
