/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /u/fowler/RCS/plclass.c,v 1.19 1993/02/17 01:59:50 fowler Exp $ */


/*
 * Initialize the PolyList class record.
 */

#include	"npolylistP.h"


static GeomClass *aNPolyListMethods = NULL;
extern NPolyList *NPolyListDraw(NPolyList *);
extern NPolyList *NPolyListCreate(NPolyList *exist, GeomClass *classp, va_list a_list);
extern NPolyList *NPolyListCopy(NPolyList *);
extern NPolyList *NPolyListFSave(NPolyList *, FILE *outf, char *fname);
extern NPolyList *NPolyListDelete(NPolyList *);

int	NPolyListPresent = 1;

static char npolylistName[] = "npolylist";

char *
NPolyListName()
{
	return npolylistName;
}

GeomClass      *
NPolyListMethods()
{
	if (!aNPolyListMethods)
	{
		aNPolyListMethods = GeomClassCreate(npolylistName);
		aNPolyListMethods->name = (GeomNameFunc *) NPolyListName;
		aNPolyListMethods->methods = (GeomMethodsFunc *) NPolyListMethods;
		aNPolyListMethods->draw = (GeomDrawFunc *) NPolyListDraw;
		aNPolyListMethods->bound = (GeomBoundFunc *) NPolyListBound;
		aNPolyListMethods->create = (GeomCreateFunc *) NPolyListCreate;
		aNPolyListMethods->copy = (GeomCopyFunc *) NPolyListCopy;
		aNPolyListMethods->fsave = (GeomFSaveFunc *) NPolyListFSave;
		aNPolyListMethods->Delete = (GeomDeleteFunc *) NPolyListDelete;
		aNPolyListMethods->fload = (GeomFLoadFunc *) NPolyListFLoad;
	}
	return aNPolyListMethods;
}
