/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <ctype.h>
#include "ndmeshP.h"

static int
getmeshvert(FILE *file, int flag, int pdim, int u, int v, HPointN **p,
		ColorA *c, Point3 *t)
{
	float	inputs[128];
	int readdim = flag&MESH_4D ? pdim+1 : pdim;
	int binary = flag&MESH_BINARY;

	inputs[pdim] = 1.0;
	if (fgetnf(file, readdim, inputs, binary) < readdim)
	    return 0;

	*p = HPtNCreate(pdim+1, inputs);

	if (flag & MESH_C && fgetnf(file, 4, (float *)c, binary) < 4)
		return 0;

	if (flag & MESH_U && fgetnf(file, 3, (float *)t, binary) < 3)
		return 0;

	return 1;
}

static int
getheader(FILE *file, int *dimp)
{
	int c, i, flag, dim;
	static char keys[] = "CN4HUuv";
	static short bit[] =
	 { MESH_C, MESH_N, MESH_4D, MESH_4D, MESH_U, MESH_UWRAP, MESH_VWRAP };

	    /* Parse [C][N][Z][4][U][u][v]MESH[ BINARY]\n */

	flag = 0;
	c = fgetc(file);
	for(i = 0; keys[i] != '\0'; i++) {
	    if(c == keys[i]) {
		flag |= bit[i];
		c = fgetc(file);
	    }
	}
	ungetc(c, file);
	if(fexpectstr(file, "nMESH"))
	    return(-1);

	if(fgetni(file, 1, dimp, 0) <= 0)
	    return -1;

	if(fnextc(file, 1) == 'B') {
	    if(fexpectstr(file, "BINARY"))
		return(-1);
	    flag |= MESH_BINARY;
	    if(fnextc(file, 1) == '\n')
		(void) fgetc(file);	/* Toss \n */
	}
	return(flag);
}


NDMesh *
NDMeshFLoad(file, fname)
	FILE *file;
	char *fname;
{
	NDMesh	m;
	int	n;
	Point3	*p3;
	int i, u, v;
	int size[2];
	int binary;

	if (!file)
		return NULL;

	if((m.flag = getheader(file, &m.pdim)) == -1)
		return NULL;

	m.meshd = 2;	/* Hack.  Should allow general meshes */

	binary = m.flag & MESH_BINARY;

	if (fgetni(file, m.meshd, size, binary) < 2) {
	    OOGLSyntax(file,"Reading nMESH from \"%s\": expected mesh grid size", fname);
	    return NULL;
	}
	if(size[0] <= 0 || size[1] <= 0 || size[0] > 9999999 || size[1] > 9999999) {
	    OOGLSyntax(file,"Reading nMESH from \"%s\": invalid mesh size %d %d",
		fname,size[0],size[1]);
	    return NULL;
	}

	n = size[0] * size[1];

	m.p = OOGLNewNE(HPointN *, n, "NDMeshFLoad: vertices");
	m.u = NULL;
	m.c = NULL;

	if (m.flag & MESH_C)
	    m.c = OOGLNewNE(ColorA, n, "NDMeshFLoad: colors");
	if (m.flag & MESH_U)
	    m.u = OOGLNewNE(Point3, n, "NDMeshFLoad: texture coords");

	for (i = 0, v = 0; v < size[1]; v++) {
	    for (u = 0; u < size[0]; u++, i++) {
		if(getmeshvert(file, m.flag, m.pdim, u, v,
			&m.p[i], &m.c[i], &m.u[i]) == 0) {
		    OOGLSyntax(file,
		"Reading nMESH from \"%s\": bad element (%d,%d) of (%d,%d)",
			    fname, u,v, size[0],size[1]);
		    return NULL;
		}
	    }
	}
	return (NDMesh *) GeomCCreate (NULL, NDMeshMethods(), CR_NOCOPY,
		CR_MESHDIM, 2, CR_MESHSIZE, size, CR_DIM, m.pdim,
		CR_4D, (m.flag & MESH_4D), CR_FLAG, m.flag,
		CR_POINT4, m.p, CR_COLOR, m.c, CR_U, m.u, CR_END);
}
