/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"
#include "ndmeshP.h"

/* Hack.  Use BBox_ND_hack() to compute a bounding box that conservatively
 * covers everything -- but ignoring the transform.
 */
BBox *
NDMeshBound(NDMesh *m, Transform T)
{
	register HPointN **p;
	int i, n;
	BBox *b = NULL;

#ifdef BBOX_ND_HACK
	for(i = m->meshd, n = 1; --i >= 0; ) n *= m->mdim[i];
	for(p = m->p; --n >= 0; p++)
	    if(*p)
		b = BBox_ND_hack(b, (*p)->v, (*p)->dim);
#endif
	return b;
}

