/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

Mesh           *
MeshFSave(m, outf)
Mesh           *m;
FILE           *outf;
{
	int             i, j;
	register HPoint3 *p = m->p;
	register Point3 *n = m->n;
	register ColorA *c = m->c;
	register Point3 *u = m->u;

	if (!outf || !m)
		return NULL;
	if (m->n == NULL)
		m->flag &= ~MESH_N;
	if (m->c == NULL)
		m->flag &= ~MESH_C;
	if (m->u == NULL)
		m->flag &= ~MESH_U;

	if (m->flag & MESH_C) fputc('C', outf);
	if (m->flag & MESH_N) fputc('N', outf);
	if (m->flag & MESH_Z) fputc('Z', outf);
	if (m->geomflags & VERT_4D) fputc('4', outf);
	if (m->flag & MESH_U) fputc('U', outf);
	if (m->flag & MESH_UWRAP) fputc('u', outf);
	if (m->flag & MESH_VWRAP) fputc('v', outf);
	if (m->flag & MESH_BINARY)    /* Hack -- should be sent by context */
	{
	    fprintf(outf, "MESH BINARY\n");
	    fwrite(&m->nu, 4, 1, outf);
	    fwrite(&m->nv, 4, 1, outf);
	    for (i = 0; i < m->nv; i++) {
		for (j = 0; j < m->nu; j++) {
		    if (m->flag & MESH_Z) fwrite(&p->z, 4, 1, outf);
		    else if (m->flag & MESH_4D) fwrite(p, 4, 4, outf);
		    else fwrite(p, 4, 3, outf);
		    p++;
		    if (m->flag & MESH_N) { fwrite(n, 4, 3, outf); n++; }
		    if (m->flag & MESH_C) { fwrite(c, 4, 4, outf); c++; }
		    if (m->flag & MESH_U) { fwrite(u, 4, 3, outf); u++; }
		}
	    }
	}
	else
	{
	    fprintf(outf, "MESH\n%d %d\n", m->nu, m->nv);
	    for (i = 0; i < m->nv; i++) {
		for (j = 0; j < m->nu; j++) {
		    if(!(m->flag & MESH_Z))
			fprintf(outf, "%g %g ", p->x, p->y);
		    fprintf(outf, "%g ", p->z);
		    if (m->geomflags & VERT_4D)
		        fprintf(outf, "%g ", p->w);
		    p++;
		    if (m->flag & MESH_N) {
			    fprintf(outf, " %g %g %g ", n->x, n->y, n->z);
			    n++;
		    }
		    if (m->flag & MESH_C) {
			    fprintf(outf, " %.3g %.3g %.3g %.3g ",
				c->r, c->g, c->b, c->a);
			    c++;
		    }
		    if (m->flag & MESH_U) {
			    fprintf(outf, " %g %g %g", u->x, u->y, u->z);
			    u++;
		    }
		    fputc('\n', outf);
		}
		fputc('\n', outf);
	    }
	}

	return m;
}


Mesh           *
MeshSave(m, name)
Mesh           *m;
char           *name;
{
	Mesh           *tm;
	FILE           *outf;

	outf = fopen(name, "w");
	if (!outf)
	{
		perror(name);
		return NULL;
	}
	tm = MeshFSave(m, outf);
	fclose(outf);

	return (m);
}
