/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include "meshP.h"
#include "pickP.h"
#include "appearance.h"

Mesh *
MeshPick(Mesh *mesh, Pick *pick, Appearance *ap, Transform T)
{
  Point3 plist[4], *meshpt;
  int i, nu, nv, maxnu, maxnv, maxpt;
  int foundu, foundv;
  unsigned int apflag;

  foundu = foundv = -1;

  maxnu = mesh->nu;
  maxnv = mesh->nv;
  maxpt = maxnu * maxnv;

  /* Make sure that vects do not register as visible - otherwise they
   * will wreck havoc with the edge picking stuff. */
  if (ap != NULL) {
    apflag = ap->flag;
    ap->flag ^= (ap->flag & APF_VECTDRAW) ? APF_VECTDRAW : 0;
  }

  /* Make a copy of the points of the mesh so we only have to 
   * transform them once. */
  meshpt = OOGLNewNE(Point3, maxpt, "meshpt array");
  for (i = 0; i < maxpt; i++) HPt3TransPt3(T, &mesh->p[i], &meshpt[i]);

  for (nv = 0; nv < ((mesh->flag & MESH_VWRAP) ? maxnv : maxnv - 1); nv++)
    for (nu = 0; nu < ((mesh->flag & MESH_UWRAP) ? maxnu : maxnu - 1); nu++) {
      plist[0] = MESHPOINT(nu, nv, mesh, meshpt);
      plist[1] = MESHPOINT(nu + 1, nv, mesh, meshpt);
      plist[2] = MESHPOINT(nu + 1, nv + 1, mesh, meshpt);
      plist[3] = MESHPOINT(nu, nv + 1, mesh, meshpt);
      if (PickFace(4, plist, pick, ap)) {
	foundu = nu;
	foundv = nv;
      }
    }

  if (meshpt != NULL) OOGLFree(meshpt);

  if (ap != NULL) ap->flag = apflag;

  if (foundu == -1) return NULL;

  if (pick->found & PW_VERT) {
    pick->vi = MESHINDEX(foundu + ((pick->vi == 1 || pick->vi == 2) ? 1 : 0), 
			 foundv + pick->vi/2, mesh);
    HPt3Transform(T, &mesh->p[pick->vi], &pick->v);
  }
  if (pick->found & PW_EDGE) {
    pick->ei[0] = 
      MESHINDEX(foundu + ((pick->ei[0] == 1 || pick->ei[0] == 2) ? 1 : 0), 
		foundv + pick->ei[0]/2, mesh);
    pick->ei[1] = 
      MESHINDEX(foundu + ((pick->ei[1] == 1 || pick->ei[1] == 2) ? 1 : 0), 
		foundv + pick->ei[1]/2, mesh);
    HPt3Transform(T, &mesh->p[pick->ei[0]], &pick->e[0]);
    HPt3Transform(T, &mesh->p[pick->ei[1]], &pick->e[1]);
  }
  if (pick->found & PW_FACE) {
    pick->f = OOGLNewNE(HPoint3, 4, "Mesh pick");
    pick->fi = MESHINDEX(foundu, foundv, mesh);
    HPt3Transform(T, &MESHPOINT(foundu, foundv, mesh, mesh->p), 
		  &pick->f[0]);
    HPt3Transform(T, &MESHPOINT(foundu+1, foundv, mesh, mesh->p), 
		  &pick->f[1]);
    HPt3Transform(T, &MESHPOINT(foundu+1, foundv+1, mesh, mesh->p), 
		  &pick->f[2]);
    HPt3Transform(T, &MESHPOINT(foundu, foundv+1, mesh, mesh->p), 
		  &pick->f[3]);
  }

  TmCopy(T, pick->Tprim);

  return mesh;
}
