/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"
#include "mgP.h"
#include "hpointn.h"
#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

static
draw_projected_mesh(mgmapfunc NDmap, void *NDinfo, Mesh *mesh)
{
    Mesh m = *mesh;
    HPointN *h = HPtNCreate(5, NULL);
    HPoint3 *op, *np;
    int i, colored = 0;
    int npts = m.nu * m.nv;
    m.p = (HPoint3 *)alloca(npts*sizeof(HPoint3));
    m.n = NULL;
    m.c = (ColorA *)alloca(npts*sizeof(ColorA));
    for(i = 0, op = mesh->p, np = m.p; i < npts; i++, op++, np++) {
	/* Set the point's first four components from our 4-D mesh vertex */
	*(HPoint3 *)h->v = *op;
	colored = (*NDmap)(NDinfo, h, np, &m.c[i]);
    }
    m.flag &= ~MESH_4D;
    if(colored) m.flag |= MESH_C;
    MeshComputeNormals(&m);
    mgmesh(m.flag, m.nu, m.nv, m.p, m.n, colored ? m.c : mesh->c);
    OOGLFree(m.n);
    HPtNDelete(h);
}

Mesh *
MeshDraw(register Mesh *mesh)
{
  /* We pass mesh->flag verbatim to mgmesh() -- MESH_[UV]WRAP == MM_[UV]WRAP */

  if(!(mesh->flag & MESH_N)) {
    Appearance *ap;

    ap = mggetappearance();
    if(ap->shading != APF_CONSTANT || ap->flag & APF_NORMALDRAW)
	MeshComputeNormals(mesh);
  }

  if(_mgc->NDinfo) {
    Transform T;
    float focallen;
    mgpushtransform();
    CamGet(_mgc->cam, CAM_FOCUS, &focallen);
    TmTranslate(T, 0., 0., -focallen);
    TmConcat(T, _mgc->C2W, T);
    mgsettransform(T);
    draw_projected_mesh(_mgc->NDmap, _mgc->NDinfo, mesh);
    mgpoptransform();
  } else if (_mgc->space & TM_CONFORMAL_BALL) {
    cmodel_clear(_mgc->space);
    cm_draw_mesh(mesh);
  } else if(_mgc->astk->useshader) {
	int i, npts = mesh->nu * mesh->nv;
	ColorA *c = (ColorA *)alloca(npts * sizeof(ColorA));
	if(mesh->c && !(_mgc->astk->mat.override & MTF_DIFFUSE)) {
	    (*_mgc->astk->shader)(npts, mesh->p, mesh->n, mesh->c, c);
	} else {
	    for(i = 0; i < npts; i++) {
		(*_mgc->astk->shader)(1, mesh->p + i, mesh->n + i,
			(ColorA *)&_mgc->astk->mat.diffuse, c + i);
	    }
	}
	mgmesh(mesh->flag | MESH_C, mesh->nu, mesh->nv, mesh->p, mesh->n, c);
  } else {
    mgmesh(mesh->flag, mesh->nu, mesh->nv, mesh->p, mesh->n, mesh->c);
  }
  return mesh;
}


