/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"
#include "meshP.h"

BBox *
MeshBound(mesh, T)
	Mesh	*mesh;
	Transform T;
{
	register int	n;
	register HPoint3 *p;
	HPoint3	min, max;
	HPoint3	p0;

	n = mesh->nu * mesh->nv;
	p = mesh->p;

#ifdef BBOX_ND_HACK
	if(mesh->flag & MESH_4D)
	    return BBox_ND_hack(NULL, (float *)p, 4*n);
#endif

	while(--n >= 0 && !finite(p->x + p->y + p->z))
		p++;
	if(n <= 0)
		return NULL;	/* No finite elements! */
	min = *p;
	HPt3TransPt3(T, p, &min);
	min.w = 1.;
	max = min;
	while(--n >= 0) {
		p++;
            	if (T != TM_IDENTITY)
			HPt3TransPt3(T, p, &p0);
		else if(p->w == 1.)
			p0 = *p;
		else
			HPt3Normalize(p, &p0);
		if(min.x > p0.x) min.x = p0.x;
		else if(max.x < p0.x) max.x = p0.x;
		if(min.y > p0.y) min.y = p0.y;
		else if(max.y < p0.y) max.y = p0.y;
		if(min.z > p0.z) min.z = p0.z;
		else if(max.z < p0.z) max.z = p0.z;
	}
	return (BBox *) GeomCCreate(NULL,BBoxMethods(), CR_MIN, &min, CR_MAX, &max, NULL);
}

