/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef LISTDEF
#define LISTDEF

#include "bbox.h"

#define LISTMAGIC	GeomMagic ('l', 1)

typedef struct List List;

extern Geom *ListRemove( Geom *list, Geom *car_of_member );
extern Geom *ListAppend( Geom *list, Geom *new_member_car );

extern GeomClass *ListClass;
extern GeomClass *ListMethods( void );
extern char *ListName( void );
extern List *ListLoad( char *fname );
extern List *ListFLoad( FILE *f, char *fname );
extern BBox *ListBound( List *, Transform );
extern Geom *ListBoundSphere( List *, Transform, int );
extern List *ListTransform( List *, Transform );
extern List *ListTransformTo( List *, Transform );
extern List *ListRotate( List *, float, Point * );
extern List *ListTranslate( List *, float, float, float );
extern List *ListScale( List *, float, float, float );
extern List *ListEvert( List * );
extern Geom *ListReplace( List *, Geom * );
extern List *ListDraw( List * );
extern List *ListSave( List *, char * );
extern List *ListFSave( List *, FILE *file, char *fname );

extern int  ListGet( List *, int attr, void *attrp );
extern List *ListImport( Pool * );

#endif /*LISTDEF*/
