#include "geom.h"
#include "create.h"
#include "instP.h"
#include "sphere.h"

Geom *InstBoundSphere(inst, T, space)
     Inst *inst;
     Transform T;
     int space;
{
  register Sphere *geomsphere, *sphere;
  Transform Tnew;
  GeomIter *it;

  if (inst == NULL || inst->geom == NULL) return NULL;

  it = GeomIterate((Geom *)inst, DEEP);
  geomsphere = NULL;
  while (NextTransform(it, Tnew) > 0) {
    TmConcat(Tnew, T, Tnew);
    sphere = (Sphere *)GeomBoundSphere(inst->geom, Tnew, space);
    if (sphere != NULL) {
      if (geomsphere != NULL) {
	SphereUnion3(geomsphere, sphere, geomsphere);
	GeomDelete((Geom *)sphere);
      } else geomsphere = sphere;
    }
  }

  return (Geom *)geomsphere;
}
