/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "geomclass.h"
#include "handleP.h"

int PoolDoCacheFiles;

void
GeomDelete( object )
    Geom *object;
{
    if (object == NULL)
	return;

    /* If we're not caching contents of files, and this object was loaded
     * from a file, and the sole reference to it is from the Handle,
     * delete it now (and delete the handle and possibly close the file).
     */
    switch (RefDecr((Ref *)object)) {
    case 1:
	if(object->handle && object->handle->whence
		&& object->handle->object == (Ref *)object
		&& !PoolDoCacheFiles) {

	    HandleDelete(object->handle);
	}
	return;
    default:
	if(object->ref_count < 0 || object->ref_count > 1000) { /* XXX debug */
	    OOGLError(1, "GeomDelete(%x) -- ref count %d?", object,
		object->ref_count);
	    return;
	}
	return;
    case 0:
	/* Actually delete it */;
    }

    if(object->ap) {
	ApDelete(object->ap);
	object->ap = NULL;
    }
    if(object->aphandle)
	HandlePDelete(&object->aphandle);
    if(object->Class->Delete) {
	(*object->Class->Delete)(object);
    }
    if(object->handle && HandleObject(object->handle) == (Ref *)object)
	HandleDelete(object->handle);
    object->magic = -1;
    OOGLFree(object);
}
