/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mg.h"
#include "bboxP.h"

BBox *
BBoxDraw(bbox)
     register BBox *bbox;
{
    register int i, k, numvert;
    int dimn;
    HPoint3 vert[16];
    Color *edgecolor;
    Appearance *ap = mggetappearance();

    if(!(ap->flag & APF_EDGEDRAW))
	return bbox;

    dimn = (bbox->geomflags & VERT_4D) ? 4 : 3;
    if (dimn == 3)	{	/* dehomogenize min, max vals */
	HPt3Normalize(&bbox->min, &bbox->min);
	HPt3Normalize(&bbox->max, &bbox->max);
	}

    /* fill in the vertices of the (hyper) cube */
    for(i = 0; i < (1 << dimn); i++) {
	vert[i].x = i&1 ? bbox->min.x : bbox->max.x;
	vert[i].y = i&2 ? bbox->min.y : bbox->max.y;
	vert[i].z = i&4 ? bbox->min.z : bbox->max.z;
	vert[i].w = i&8 ? bbox->min.w : bbox->max.w;
    }

    numvert = 1 << dimn;

    /* turn on the edge color to draw the bbox */

    edgecolor = &ap->mat->edgecolor;
    for(i = 0; i < numvert; i++) {
	int j, incr;
	HPoint3 edge[2];

	for(j = 0; j < dimn; j ++) {
	    /* connect this vertex to its nearest neighbors if they
	     * follow it in lexicographical order */
	    incr = 1 << j;
	    /* is the j_th bit a zero? */
	    if ( ! (i & incr) )	{
		/* if so, draw the edge to the vertex whose number is
		 * gotten from i by making the j_th bit a one */
		edge[0] = vert[i];
		edge[1] = vert[i + incr];
		mgpolyline(2, edge, 1,  edgecolor, 0) ;
	    }
	}
    }
    return bbox;
}
