/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

static GeomClass *aBBoxMethods = NULL;

int BBoxPresent = 1;

static char bboxName[] = "bbox";

extern BBox *BBoxCopy ( BBox * );
extern Geom *BBoxCreate ( va_list );
extern BBox *BBoxDelete ( BBox * );

extern BBox *BBoxFSave( BBox *, FILE *, char * );
extern BBox *BBoxFLoad( FILE *, char * );

char *
BBoxName()
{
	return bboxName;
}

GeomClass      *
BBoxMethods()
{
	if (!aBBoxMethods)
	{
		aBBoxMethods = GeomClassCreate(bboxName);
		aBBoxMethods->name = (GeomNameFunc *) BBoxName;
		aBBoxMethods->bound = (GeomBoundFunc *) BBoxBound;
		aBBoxMethods->copy = (GeomCopyFunc *) BBoxCopy;
		aBBoxMethods->create = (GeomCreateFunc *) BBoxCreate;
		aBBoxMethods->draw = (GeomDrawFunc *) BBoxDraw;
		aBBoxMethods->methods = (GeomMethodsFunc *) BBoxMethods;
		aBBoxMethods->name = (GeomNameFunc *) BBoxName;
		aBBoxMethods->transform = (GeomTransformFunc *) BBoxTransform;
		aBBoxMethods->fsave = (GeomFSaveFunc *) BBoxFSave;
		aBBoxMethods->fload = (GeomFLoadFunc *) BBoxFLoad;
		/*
		 * Note we need no delete method -- GeomDelete does all.
		 */
	}
	return aBBoxMethods;
}
