/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	Tm3Tetrad
 * Description:	create a matrix with given vectors as rows
 * Args:	T: the created matrix (OUTPUT)
 *		x: row 1 (INPUT)
 *		y: row 2 (INPUT)
 *		z: row 3 (INPUT)
 *		w: row 4 (INPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 13:06:48 1991
 * Notes:	
 */
void
Tm3Tetrad( T, x, y, z, w )				
    Transform3 T;
    HPoint3 *x, *y, *z, *w;
{
    T[X][X] = x->x;
    T[X][Y] = x->y;
    T[X][Z] = x->z;
    T[X][W] = x->w;

    T[Y][X] = y->x;
    T[Y][Y] = y->y;
    T[Y][Z] = y->z;
    T[Y][W] = y->w;

    T[Z][X] = z->x;
    T[Z][Y] = z->y;
    T[Z][Z] = z->z;
    T[Z][W] = z->w;

    T[W][X] = w->x;
    T[W][Y] = w->y;
    T[W][Z] = w->z;
    T[W][W] = w->w;
}
