/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include <math.h>
#include "radians.h"
#include "transform3.h"
#include "ooglutil.h"	/* For OOGLError() */

/*
 *
 *     ( cot(fov/2)/aspect       0           0           0	)
 *     (         0          cot(fov/2)       0           0	)
 * T = (         0               0     -(f+n)/(f-n)     -1	)
 *     (         0               0     -2*f*n/(f-n)      0	)
 *
 * Transform to the unit cube. Also flip from rh to lh.
 */
void
Tm3PerspectiveFOV( T, fov, aspect, n, f )
    Transform3 T;
    float fov, aspect, n, f;
{
    float cotfov;

    Tm3Identity( T );

    if( n == f ) {
	OOGLError(1/*UserError*/, "Tm3Perspective: n and f must be different" );
	return;
    }
    if( fov == 0. ) {
	OOGLError(1/*UserError*/, "Tm3Perspective: fov must not equal 0" );
	return;
    }

    cotfov = tan( RADIANS(fov)/2.0 );
    if( cotfov != 0. )
	cotfov = 1. / cotfov;


    T[X][X] =  cotfov/aspect;
    T[Y][Y] =  cotfov;
    T[Z][Z] = -2*(f+n)/(f-n);
    T[W][Z] = -2*f*n/(f-n);
    T[X][W] = -1.;
    T[W][W] =  0.;
}
