/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef COLORDEFS
#define COLORDEFS

typedef struct { float r, g, b;   } Color;
typedef struct { float r, g, b, a; } ColorA;

extern void CoPrint(Color *c);
extern void CoCopy(Color *c0, Color *c1);
extern void CoACopy(ColorA *c0, ColorA *c1);
extern void CoFrom(Color *c, float r, float g, float b);
extern void CoAdd(Color *c0, Color *c1, Color *c2);
extern void CoSub(Color *c0, Color *c1, Color *c2);
extern void CoFilter(Color *c0, Color *c1, Color *c2);

#endif
