#ifndef WARP_H
#define WARP_H

#define MIN_A 		.1
#define MAX_A 		10000.0
#define DEF_A 		(0.75 * MAX_A)
#define MIN_B 		0.0
#define MAX_B 		5.0
#define DEF_B 		4.0

#define DEF_OBJECT 	"targetgeom"

#define DEF_INT_STEPS 	10

#define DEF_GRIDX 	3
#define DEF_GRIDY 	3
#define DEF_GRIDZ 	3

#define DEF_WIDGET_GEOM	"unitcube.off"
#define DEF_WIDGET_SIZE	.1

#define DEF_PREFIX	"warp."
#define DEF_PATH	"./"

#define WIDGET_NAMELEN 64

typedef char WidgetName[WIDGET_NAMELEN];

typedef struct {
  HPoint3 RestLocation;
  HPoint3 TransLocation;
  Transform T;
  float a, b;
} WarpZone;

void WarpPoint(HPoint3 *old, HPoint3 *new, WarpZone *wz, int n_wz, 
	       int step, int totsteps);
void WarpPointN(HPoint3 *old, HPoint3 *new, int n, WarpZone *wz, int n_wz,
		int step, int totsteps);

#define WIDGET_NAME(s, i) sprintf((s), "ControlPoint%d", (i))
#define WIDGET_GRIDNAME(s, x, y, z) \
  sprintf((s), "Point_%d_%d_%d", (x), (y), (z))

void WidgetCreateAt(float x, float y, float z);
void WidgetCreateAtNamed(float x, float y, float z, const char *name);
void WidgetCreate(const char *name, float x, float y, float z, float scale,
		  const char *geom);
void WidgetDelete(const char *name);

void WidgetLocation(const char *name, float x, float y, float z);

void WidgetGetTransform(const char *name, Transform T);
void WidgetSetTransform(const char *name, Transform T);

void freeze();
void thaw();

#endif /* WARP_H */
