
#import "point3.h"
#import "api.h"
#import "Warp.h"

@implementation Warp
;

static id mainWindowID;
static id targetFieldID, createOnPickButtonID;
static id optionsObjectID, editObjectID, errorObjectID;
static id selfID;

void StdinProc(int fd, void *userData);

- appDidInit:sender
{
  [mainWindow setAvoidsActivation:YES];
  mainWindowID = mainWindow;
  targetFieldID = targetField;
  createOnPickButtonID = createOnPickButton;
  editObjectID = editObject;
  errorObjectID = errorObject;
  optionsObjectID = optionsObject;
  selfID = self;

  DPSAddFD(0, StdinProc, NULL, 1);
  apiInit();

  return self;
}

- appWillTerminate:sender
{
  apiExit();
  return self;
}


- delete:sender
{
  apiDelete();
  return self;
}

- deleteAll:sender
{
  apiDeleteAll();
  return self;
}

- object:sender
{
  apiTargetChanged();
  return self;
}

- position:sender
{
  apiPosition();
  [positionOnGridButton setState:0];
  return self;
}

- preview:sender
{
  apiPreview();
  [previewButton setState:0];
  return self;
}

- warp:sender
{
  apiWarp();
  [warpButton setState:0];
  return self;
}

- freeze
{
  return self;
}

- thaw
{
  return self;
}

void StdinProc(int fd, void *userData) {
  apiDoPipes();
}

/* Things implemented in machine-specific code to be called by common
 * code */

void uiFreeze() {
  [selfID freeze];
}

void uiThaw() {
  [selfID thaw];
}

void uiSetTarget(const char *target) {
  [targetFieldID setStringValue:target at:0];
}

const char *uiGetTarget() {
  return [targetFieldID stringValueAt:0];
}

void uiSetCreateOnPick(int val) {
  [createOnPickButtonID setState:val];
}

int uiGetCreateOnPick() {
  return [createOnPickButtonID state];
}

@end
