
#import <stdio.h>
#import "point3.h"
#import "api.h" 
#import "OptionsObject.h"

@implementation OptionsObject
;
static id autoUpdateID;
static id gridSizeID;
static id numberStepsID;
static id pathID;
static id prefixID;
static id retainID;
static id sendFilesID;
static id sendGeomviewID;
static id sizeRelativelyID;
static id stepsFormID;
static id widgetGeomID;
static id widgetSizeID;

- awakeFromNib
{
  autoUpdateID = autoUpdate;
  gridSizeID = gridSize;
  numberStepsID = numberSteps;
  pathID = path;
  prefixID = prefix;
  retainID = retain;
  sendFilesID = sendFiles;
  sendGeomviewID = sendGeomview;
  sizeRelativelyID = sizeRelatively;
  stepsFormID = stepsForm;
  widgetGeomID = widgetGeom;
  widgetSizeID = widgetSize;
  [optionsPanel setAvoidsActivation:YES];
  return self;
}

- changeWidgetGeom:sender
{
  apiUpdateGeom();
  return self;
}

- changeWidgetSize:sender
{
  apiUpdateScale();
  return self;
}

void uiSetSteps(int steps) {
  [numberStepsID setIntValue:steps at:0];
}

int uiGetSteps() {
  return [numberStepsID intValueAt:0];
}

void uiSetStart(int start) {
  [stepsFormID setIntValue:start at:0];
}

int uiGetStart() {
  return [stepsFormID intValueAt:0];
}

void uiSetEnd(int end) {
  [stepsFormID setIntValue:end at:1];
}

int uiGetEnd() {
  return [stepsFormID intValueAt:1];
}

void uiSetIntToGV(int val) {
  [sendGeomviewID setState:val];
}

int uiGetIntToGV() {
  return [sendGeomviewID state];
}

void uiSetIntToFiles(int val) {
  [sendFilesID setState:val];
}

int uiGetIntToFiles() {
  return [sendFilesID state];
}

void uiSetAutoUpdate(int val) {
  [autoUpdateID setState:val];
}

int uiGetAutoUpdate() {
  return [autoUpdateID state];
}

void uiSetRetain(int val) {
  [retainID setState:val];
}

int uiGetRetain() {
  return [retainID state];
}

void uiSetPrefix(const char *prefix) {
  [prefixID setStringValue:prefix at:0];
}

const char *uiGetPrefix() {
  return [prefixID stringValueAt:0];
}

void uiSetPath(const char *path) {
  [pathID setStringValue:path at:0];
}

const char *uiGetPath() {
  return [pathID stringValueAt:0];
}

void uiSetWidgetGeom(const char *geom) {
  [widgetGeomID setStringValue:geom at:0];
}

const char *uiGetWidgetGeom() {
  return [widgetGeomID stringValueAt:0];
}

void uiSetWidgetSize(float size) {
  [widgetSizeID setFloatValue:size at:0];
}

float uiGetWidgetSize() {
  return [widgetSizeID floatValueAt:0];
}

void uiSetRelativeSize(int val) {
  [sizeRelativelyID setState:val];
}

int uiGetRelativeSize() {
  return [sizeRelativelyID state];
}

void uiSetGridX(int x) {
  [gridSizeID setIntValue:x at:0];
}

int uiGetGridX() {
  return [gridSizeID intValueAt:0];
}

void uiSetGridY(int y) {
  [gridSizeID setIntValue:y at:1];
}

int uiGetGridY() {
  return [gridSizeID intValueAt:1];
}

void uiSetGridZ(int z) {
  [gridSizeID setIntValue:z at:2];
}

int uiGetGridZ() {
  return [gridSizeID intValueAt:2];
}

@end

  
