#ifndef ORIGIN_COMMON_H
#define ORIGIN_COMMON_H

/*
 * Routines beginning with "internals" are found in the common code.
 */
void internalsInit();
void internalsShow();
void internalsDone();
void internalsCancel();
void internalsQuit();

/*
 * These routines are to be found in the machine-specific code and will
 * be called from the common code 
 */

/* Disable the Show button */
void uiDisableShow();
/* Enable the Show button */
void uiEnableShow();

/* Disable the Done and Cancel buttons */
void uiDisableDoneCanel();
/* Enable the Done and Cancel buttons */
void uiEnableDoneCanel();

/* Put str1, str2, and str3 as the new instructions */
void uiSetInstructions(char *str1, char *str2, char *str3, char *str4);

/* Copy the name of the target object to name */
void uiGetTargetname(char *name);
/* Set the name of the target object to name */
void uiSetTargetname(char *name);

/* Display an error message (up to 3 lines long) */
void uiError(char *str1, char *str2, char *str3);

#endif
