#include <stdio.h>

#include "mibload.h"
#include "interface/pssnap.mib"
#include "interface/info.mib"

#define Cursor _Cursor
#include "geom.h"
#include "polylistP.h"
#include "camera.h"
#include "pssnap.h"
#undef Cursor

#define min(a, b) ((a) < (b) ? (a) : (b))
#define max(a, b) ((a) > (b) ? (a) : (b))


/*****************************************************************************/

static XtAppContext  App;
static Widget	     TopLevel;
static int flag = PS_EDGES | PS_FACES | PS_COLOR;

/*****************************************************************************/

static char *get_info();
static void exit_callback(Widget , XtPointer, XmPushButtonCallbackStruct *);
static void open_callback(Widget , XtPointer, XmPushButtonCallbackStruct *);
static void flags_callback(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void close_callback(Widget , XtPointer, XmPushButtonCallbackStruct *);
static void save_callback(Widget , XtPointer,
				XmFileSelectionBoxCallbackStruct *);

/*****************************************************************************/

void UIloadinterface()
{
  Display	*dpy;
  Widget	MainWindow, InfoWindow, InfoButton,
		ExitButton, PSTitle, InfoTitle,
		FacesToggle, EdgesToggle, ColorToggle,
		InfoText, InfoHide, SaveButton,
		FileSelect;
  XFontStruct  *font;
  XmFontList    fontlist;
  Arg		args[10];
  int		n, oldstderr;
  int		argcblah = 1;
  char 	       *argvblah[1] = { "PS Snapshot" };

  unsigned char *item;

  mib_Widget   *MainForm, *InfoForm, *CommandForm;
  String	fallbacks[] = {

#ifdef dark_ui
	"*Foreground:			gray20",
	"*Background:			gray70",
#endif
#ifdef light_ui
	"*Foreground:			#000000000000",
	"*Background:			#afafafafafaf",
#endif
	"*BorderWidth:			0",
	"*XmToggleButton.selectColor:    yellow",
	"*XmToggleButton.indicatorSize:    16",
	"*XmToggleButtonGadget.selectColor:    yellow",
	"*XmToggleButtonGadget.indicatorSize:    16",
	"*XmTextField.background:	        #cc7777",
	"*fontList:\
	-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1",
	NULL};


  /* initialize application top level widget */

  TopLevel = XtVaAppInitialize(&App, "pssnap", NULL, 0,
	&argcblah, argvblah, fallbacks, NULL);

  dpy = XtDisplay(TopLevel);

  oldstderr = dup(fileno(stderr));
  freopen("/dev/null", "w", stderr);

  /* configure resize policy of window */

  XtVaSetValues(TopLevel, XmNminWidth, 190, XmNminHeight, 187,
			XmNmaxWidth, 190, XmNmaxHeight, 187,
			XmNkeyboardFocusPolicy, XmPOINTER, NULL);

  /* create the application windows */

  MainWindow = XtCreateManagedWidget("MainWindow",
	xmMainWindowWidgetClass, TopLevel, NULL, 0);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNminWidth, 190); n++;
  XtSetArg(args[n], XmNminHeight, 187); n++;
  XtSetArg(args[n], XmNtitle, "Info"); n++;

  InfoWindow = XmCreateFormDialog(MainWindow, "Info", args, n);

/*****************************************************************************/

  n = 0;
  XtSetArg (args[n], XmNtitle, "Files"); n++;
  XtSetArg (args[n], XmNwidth, 375); n++;
  XtSetArg (args[n], XmNheight, 380); n++;
  XtSetArg (args[n], XmNnoResize, True); n++;
  XtSetArg (args[n], XmNresizePolicy, XmRESIZE_NONE); n++;

  FileSelect = XmCreateFileSelectionDialog(MainWindow, "Files", args, n);
  XtAddCallback(FileSelect, XmNcancelCallback, (XtCallbackProc)close_callback, FileSelect);
  XtAddCallback(FileSelect, XmNokCallback, (XtCallbackProc)save_callback, (XtPointer) NULL);
  XtUnmanageChild(XmFileSelectionBoxGetChild(FileSelect,XmDIALOG_HELP_BUTTON));


/*****************************************************************************/

  /* load the interface via the mib library */

/*
  MainForm = mib_load_interface(MainWindow,
	"interface/pssnap.mib", MI_FROMFILE);

  InfoForm = mib_load_interface(InfoWindow,
	"interface/info.mib", MI_FROMFILE);
*/

  MainForm = mib_load_interface(MainWindow, PSRoot, MI_FROMSTRING);
  InfoForm = mib_load_interface(InfoWindow, InfoRoot, MI_FROMSTRING);


  /* Get widget pointers from interface */

  ExitButton = mib_find_name(MainForm, "ExitButton")->me;
  InfoButton = mib_find_name(MainForm, "InfoButton")->me;
  FacesToggle = mib_find_name(MainForm, "FacesToggle")->me;
  EdgesToggle = mib_find_name(MainForm, "EdgesToggle")->me;
  ColorToggle = mib_find_name(MainForm, "ColorToggle")->me;
  PSTitle = mib_find_name(MainForm, "PSTitle")->me;
  SaveButton = mib_find_name(MainForm, "SnapShot")->me;

  InfoHide = mib_find_name(InfoForm, "Close")->me;
  InfoText = mib_find_name(InfoForm, "TextBig")->me;
  InfoTitle = mib_find_name(InfoForm, "Title")->me;

  /* Set large font for titles */

  font = XLoadQueryFont(dpy,
        "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1");
  fontlist = XmFontListCreate(font, "bigger");
  XtVaSetValues(PSTitle, XmNfontList, fontlist, NULL);
  XtVaSetValues(InfoTitle, XmNfontList, fontlist, NULL);

  /* Set various resources and values */

  XtVaSetValues(InfoText, XmNcursorPositionVisible, False,
                           XmNeditable, False, NULL);
  XmTextSetString(InfoText, get_info());

  XmToggleButtonSetState(FacesToggle, 1, False);
  XmToggleButtonSetState(EdgesToggle, 1, False);
  XmToggleButtonSetState(ColorToggle, 1, False);



  /* Set callbacks - stupid @#$@&%!@# boiler plate code */

  XtAddCallback(ExitButton,
		XmNactivateCallback,
		(XtCallbackProc)exit_callback,
		(XtPointer)NULL
		);

  XtAddCallback(InfoButton,
		XmNactivateCallback,
		(XtCallbackProc)open_callback,
		(XtPointer)InfoWindow
		);

  XtAddCallback(SaveButton,
		XmNactivateCallback,
		(XtCallbackProc)open_callback,
		(XtPointer)FileSelect
		);


  XtAddCallback(FacesToggle,
		XmNvalueChangedCallback,
		(XtCallbackProc)flags_callback,
		(XtPointer)PS_FACES
		);

  XtAddCallback(EdgesToggle,
		XmNvalueChangedCallback,
		(XtCallbackProc)flags_callback,
		(XtPointer)PS_EDGES
		);

  XtAddCallback(ColorToggle,
		XmNvalueChangedCallback,
		(XtCallbackProc)flags_callback,
		(XtPointer)PS_COLOR
		);

  XtAddCallback(InfoHide,
		XmNactivateCallback,
		(XtCallbackProc)close_callback,
		(XtPointer)InfoWindow
		);

  freopen("/dev/null", "w", stderr);
  dup2(oldstderr, fileno(stderr));
  close(oldstderr);

}

void UIshowinterface()
{
  XtRealizeWidget(TopLevel);
}

void UImainloop()
{
  /* Begin main Intrinsics event loop */

  XtAppMainLoop (App);

}

static void save_callback(Widget w, XtPointer data,
				XmFileSelectionBoxCallbackStruct *cbs)
{
  char *filename;
  int i;
  FILE *outfile = stdout, *infile = stdin;
  Camera *c;
  Geom *o, *onew;

  XtUnmanageChild(w);

  if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename))
    return;

  if ( !(*filename) )
  {
    XtFree(filename);
    return;
  }

  /* Get the current object. */
  printf("(write geometry - targetgeom )\n");
  fflush(stdout);

  if ((outfile = fopen(filename, "w")) == NULL) {
    OOGLError(0, "Unable to open output file %s", filename);
    exit(1);
  }

  o = GeomFLoad(stdin, NULL);

  printf("(write camera - targetcam)\n");
  fflush(stdout);

  c = CamFLoad(NULL, stdin, "stdin");

  /* Do the viewing transformations. */
  onew = PolyProject(o, c);
  GeomDelete(o);

  PolyToPSInit(outfile, flag);
  PolyToPS(onew, outfile, flag);
  fprintf(outfile, "showpage\n");

  fclose(outfile);

  GeomDelete(onew);

  XtFree(filename);

}


static void exit_callback(	Widget w,
				XtPointer data,
				XmPushButtonCallbackStruct *cbs)
{
  exit(0);
}

static void open_callback(	Widget w,
				XtPointer data,
				XmPushButtonCallbackStruct *cbs)
{
  XtManageChild((Widget)data);
}

static void close_callback(	Widget w,
				XtPointer data,
				XmPushButtonCallbackStruct *cbs)
{
  XtUnmanageChild((Widget)data);
}

static void flags_callback(	Widget w,
				XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{
  flag ^= (long)data;
}

/*****************************************************************************/

static char *get_info()
{
  static char info[] = "By Celeste Fowler\n\
\n\
Motif interface\n\
by Daeron Meyer\n\
\n\
Copyright (c) 1994\n\
The Geometry Center\n\
anonymous ftp: ftp.geom.umn.edu\n\
email: software@geom.umn.edu\n\
\n\
Pssnap places a PostScript image of a\n\
geomview object in a file. Pssnap is\n\
meant to be run as a geomview external module,\n\
and draws the currently selected object from\n\
the point of view of the current camera.\n\
\n\
The image is sized to fit on an 8.5 x 11 inch\n\
sheet of paper.  Pssnap uses the orientation\n\
of the surfaces to determine lighting.  When\n\
creating black and white PostScript, pssnap\n\
uses averages the r, g and b components of the\n\
color of the object using the formula\n\
\n\
grey = .299 * r + .587 * g + .114 * b.\n\
\n\
Pssnap does not support smooth shading.  If\n\
an object contains per vertex colors, the entire\n\
face is given the same color as the first\n\
vertex.\n\
";

  return info;

}

/*****************************************************************************/

main(int argc, char *argv[])
{

  UIloadinterface();

  UIshowinterface();

  UImainloop();
}

/*****************************************************************************/
