#include <stdio.h>
#include <math.h>
#include "mg.h"
#include "geom.h"

ColorA white = { 1, 1, 1, 1};		/* define some common colors */
ColorA red = { 1, 0, 0, 1};
ColorA darkblue = { 0, 0, .2, 1};
ColorA darkgray = { .1, .1, .1, .6};

Point lightpos = { 0, 0, 1, 0};		/* and a location for our light */


#ifdef __linux__
#include <fpu_control.h>
#endif

main(int argc, char *argv[])
{

    /* declare variables basic to OOGL */
    Geom	 * theObject;
    Transform 	ObjectTransform;
    Camera	 * theCamera;
    Appearance	 * theAppearance;
    WnWindow	 * theWindow;
    /* WnPosition 	windowPosition; */
    /* float	windowAspect;   */
    LmLighting	 * lightingModel;
    LtLight	 * theLight;

#ifdef __linux__
  __setfpucw(_FPU_IEEE);
#endif

    /* initialize the graphics device */

#if defined(MGGL) 	/* sgi */
    mgdevice_GL();
#elif defined(NeXT)
    mgdevice_RI();
#else			/* Sun, HPUX, DEC, Linux, ... ? */
    mgdevice_X11();
#endif


    /* create a camera */
    theCamera = CamCreate( CAM_FOV, 60.0, CAM_END );

    /* create the lighting model */
    lightingModel = LmCreate( LM_AMBIENT, &darkgray, LM_REPLACELIGHTS, 1,
				LM_END);

    /* create a light */
    theLight = LtCreate( LT_COLOR, &white, LT_POSITION, &lightpos,
				LT_INTENSITY, 1.0, LT_END);

    /* add the light to our lighting model */
    LtAppend(lightingModel, theLight);


    /* create the appearance - we specify the lighting
     * model when we create the appearance
     */
    theAppearance =  ApCreate( AP_DO, APF_FACEDRAW | APF_SHADING |
        APF_EDGEDRAW, AP_MtSet, MT_Kd, 1.0, MT_DIFFUSE, &red, MT_END, AP_LGT,
         lightingModel, AP_SHADING, APF_FLAT, AP_END);

    /* create the graphics context */
    mgctxcreate( MG_BACKGROUND, &darkblue, MG_CAMERA, theCamera, MG_APPEAR,
         theAppearance, MG_END );

	/*
	 *	theWindow = WnCreate(WN_NAME, "MyWindow",WN_END);
	 *	WnGet(theWindow, WN_ASPECT, &windowAspect);
	 *	mgctxset( MG_CAMERA,
	 *		  CamSet(theCamera, CAM_ASPECT, windowAspect,CAM_END),
	 *		  MG_END);
	 */

    /* Software shading? */
    if (argc > 1 && strcmp(argv[1], "-s") == 0) {
	mgctxset( MG_SHADER, mg_eucshade, MG_SHADERDATA, NULL, MG_END );
	argc--, argv++;
    }

    /* Read the object from a file, dodec.quad by default. */
    theObject = GeomLoad(argc > 1 ? argv[1] : "dodec.quad");

    /* we could incorporate following code into a loop (or event loop).
     * We may rotate/translate/etc. the object by changing the ObjectTransform
     * in the loop. Following is an example of a loop which rotates the object
     * around the Y axis:
     */

    while (1) {

	float	angle;
	int	i;

	/* angle increment should be small for fast systems
		 * and larger (about 1 or 2) for slow systems...
		 */
	for ( angle = 0; angle < 360.0; angle += .01) {

	    /* following will 'sync' if window size has changed */
	    mgreshapeviewport();

	    /* create a transform to rotate Y to given angle */
	    TmRotateY( ObjectTransform, angle);

	    /* now the basic block to actually draw the geometry */
	    mgworldbegin();
	    mgtransform(ObjectTransform);
	    GeomDraw(theObject);
	    mgworldend();

	}
    }
}
