extern XtAppContext App;
extern int YScrnSize;
extern int      gvbitdepth;
extern Visual  *gvvisual;
extern Colormap gvcolormap;
extern int	gvpriv;


void load_interface(unsigned int, char **);
void main_loop();

#if !defined(MGGL) && !defined(MGX11)
#define MGX11
#endif

#include "mg.h"
#ifdef MGX11
#include "mgx11.h"
#endif

#ifdef MGGL
#include "mggl.h"
#endif

#ifdef MGX11
  void cam_expose(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
#endif

#ifdef MGGL
  #include <gl/gl.h>
  #include <X11/Xirisw/GlxMDraw.h>
  void cam_exposegl(Widget, XtPointer, GlxDrawCallbackStruct *);
  void cam_initgl(Widget, XtPointer, GlxDrawCallbackStruct *);
#endif

void cam_input(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
void cam_mouse(Widget, XtPointer , XPointerMovedEvent *, Boolean *);
void cam_mousecross(Widget, XtPointer , XEnterWindowEvent *, Boolean *);
void ui_build_browser(Widget, int, char *[]);
void ui_set_ftext(Widget, float);
void ui_set_itext(Widget, int);
void ui_showpanel(int, int);
void ui_final_init();
void ui_select(int);
void ui_update();


/* Panel Defines */
/*****************************************************************************/

#define P_NULL          0
#define P_MAIN          1
#define P_TOOL          2
#define P_APPEARANCE    3
#define P_CAMERA        4
#define P_LIGHTS        5
#define P_COMMANDS      6
#define P_MATERIAL      7
#define P_CREDITS       8
#define P_SAVE          9
#define P_FILEBROWSER   10
#define P_INPUT         11
#define P_COLOR         12
#define P_MAX           12

/* Camera Methods */
/*****************************************************************************/

Widget ui_create_camera(Widget, Widget *, DView *, int *, Visual **);

/* Main Panel Methods */
/*****************************************************************************/

void   ui_load_mainpanel();
void   ui_show_mainpanel();
void   ui_hide_mainpanel();
void   ui_move_mainpanel(int, int, int);

void   ui_refresh_mainpanel();
void   ui_adjustpicklist(int);
void   ui_adjustemodulelist(int);

/* Tool Panel Methods */
/*****************************************************************************/

void   ui_load_toolpanel();
void   ui_show_toolpanel();
void   ui_hide_toolpanel();
void   ui_move_toolpanel(int, int, int);
void   ui_select_tool(int);

void   ui_tool_targetset(char *);
void   ui_tool_centerset(char *);

/* Appearance Panel Methods */
/*****************************************************************************/

void   ui_load_appearancepanel();
void   ui_show_appearancepanel();
void   ui_hide_appearancepanel();
void   ui_move_appearancepanel(int, int, int);

void   ui_target_appearancepanel(int);

/* Material Panel Methods */
/*****************************************************************************/

void   ui_load_materialpanel();
void   ui_show_materialpanel();
void   ui_hide_materialpanel();
void   ui_move_materialpanel(int, int, int);

void   ui_target_materialpanel(int);

/* Credits Panel Methods */
/*****************************************************************************/

void   ui_load_creditspanel();
void   ui_show_creditspanel();
void   ui_hide_creditspanel();
void   ui_move_creditspanel(int, int, int);

/* Save Panel Methods */
/*****************************************************************************/

void   ui_load_savepanel();
void   ui_show_savepanel();
void   ui_hide_savepanel();
void   ui_move_savepanel(int, int, int);

/* Load Panel Methods */
/*****************************************************************************/

void   ui_load_loadpanel();
void   ui_show_loadpanel();
void   ui_hide_loadpanel();
void   ui_move_loadpanel(int, int, int);

/* Command Panel Methods */
/*****************************************************************************/

void   ui_load_commandspanel();
void   ui_show_commandspanel();
void   ui_hide_commandspanel();
void   ui_move_commandspanel(int, int, int);

/* Lights Panel Methods */
/*****************************************************************************/

void   ui_load_lightspanel();
void   ui_show_lightspanel();
void   ui_hide_lightspanel();
void   ui_move_lightspanel(int, int, int);

/* Cameras Panel Methods */
/*****************************************************************************/

void   ui_load_cameraspanel();
void   ui_show_cameraspanel();
void   ui_hide_cameraspanel();
void   ui_move_cameraspanel(int, int, int);

void   ui_target_cameraspanel(int);

/* Color Panel Methods */
/*****************************************************************************/

void   ui_load_colorpanel();
void   ui_show_colorpanel();
void   ui_hide_colorpanel();
void   ui_move_colorpanel(int, int, int);

Pixel  ui_nearestRGB(float, float, float);
void ui_config_colorpanel(char *, Color *, int, int, int);

/*****************************************************************************/
