#include "mibload.h"

#include "mg.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"
#include "interface/Tool.mib"

#include "bitmaps/rotate"
#include "bitmaps/translate"
#include "bitmaps/scale"
#include "bitmaps/fly"
#include "bitmaps/zoom"
#include "bitmaps/orbit"
#include "bitmaps/stop"
#include "bitmaps/lookat"
#include "bitmaps/center"
#include "bitmaps/reset"

extern Display *dpy;
extern UIState uistate;
extern Pixmap  geomicon;

/* public methods */
/*****************************************************************************/

void   ui_load_toolpanel();
void   ui_show_toolpanel();
void   ui_hide_toolpanel();
void   ui_select_tool(int);

void   ui_tool_targetset(char *);
void   ui_tool_centerset(char *);

/* private methods and variables */
/*****************************************************************************/

static void load_tool_bitmaps(mib_Widget *);
static void hide_tools(Widget, XtPointer, XmAnyCallbackStruct *);
static void show_main(Widget, XtPointer, XmAnyCallbackStruct *);
static void target_set(Widget, XtPointer, XmAnyCallbackStruct *);
static void center_set(Widget, XtPointer, XmAnyCallbackStruct *);

static tools_loaded = 0;
static Pixmap toolpix[6][2]; /* regular and reverse for the mode buttons */
static Widget toolwidget[6]; /* Widgets for each tool */

static int last_button = TOOL_ROT; /* starts out as rotate */
static Widget shell, last, TargetText, CenterText;
static int pos_later = 0, posx = 0, posy = 0;


/*****************************************************************************/

void ui_load_toolpanel()
{
  Arg	     args[20];
  int	     n, decor, menu;
  Widget     toolform,
	     HideButton,
	     MainButton;

  mib_Widget *toolload;
  Atom       AProtocol;
  char       buf[40];
static char  geometry[40];

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Tools"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 102); n++;
  XtSetArg(args[n], XmNheight, 448); n++;
  XtSetArg(args[n], XmNminWidth, 102); n++;
  XtSetArg(args[n], XmNmaxWidth, 102); n++;
  XtSetArg(args[n], XmNminHeight, 448); n++;
  XtSetArg(args[n], XmNmaxHeight, 448); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  shell = XtAppCreateShell("Tools", "gv", topLevelShellWidgetClass, dpy,
				args, n);
  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Tools"); n++;
  XtSetArg(args[n], XmNwidth, 102); n++;
  XtSetArg(args[n], XmNminWidth, 102); n++;
  XtSetArg(args[n], XmNmaxWidth, 102); n++;
  XtSetArg(args[n], XmNheight, 448); n++;
  XtSetArg(args[n], XmNminHeight, 448); n++;
  XtSetArg(args[n], XmNmaxHeight, 448); n++;

  toolform = XmCreateForm(shell, "Tools", args, n);
/*toolload = mib_load_interface(toolform, "interface/Tool.mib", MI_FROMFILE);*/
  toolload = mib_load_interface(toolform, Root, MI_FROMSTRING);
 
 
  XtManageChild(toolform);

/*****************************************************************************/

  HideButton = mib_find_name(toolload, "HideButton")->me;
  MainButton = mib_find_name(toolload, "MainButton")->me;
  TargetText = mib_find_name(toolload, "TargetText")->me;
  CenterText = mib_find_name(toolload, "CenterText")->me;

  load_tool_bitmaps(toolload);
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) hide_tools,
			NULL);
  XtAddCallback(MainButton, XmNactivateCallback, (XtCallbackProc) show_main,
			NULL);
  XtAddCallback(TargetText, XmNactivateCallback, (XtCallbackProc) target_set,
			NULL);
  XtAddCallback(CenterText, XmNactivateCallback, (XtCallbackProc) center_set,
			NULL);


/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_tools, NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
		MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);
  tools_loaded = 1;

}


/*****************************************************************************/

void ui_show_toolpanel()
{
  if (!tools_loaded)
    return;

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_toolpanel()
{
  if (tools_loaded)
    XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_toolpanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

void ui_select_tool(int toolnum)
{
  Widget w;

  if ((toolnum >= 0) && (toolnum <= 5) && tools_loaded)
    w = toolwidget[toolnum];
  else
    return;

  XtVaSetValues(last, XmNlabelPixmap, toolpix[last_button][0], NULL);
  XtVaSetValues(w, XmNlabelPixmap, toolpix[toolnum][0], NULL);
  XtVaSetValues(w, XmNlabelPixmap, toolpix[toolnum][1], NULL);
  last_button = toolnum;
  last = w;
}

/*****************************************************************************/

static void hide_tools(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_TOOL, 0);
}

/*****************************************************************************/

static void show_main(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_MAIN, 1);
}

/*****************************************************************************/

static void modetool_callback(Widget w, XtPointer data,
				XmPushButtonCallbackStruct *cbs)
{
  int toolnum = (int) data;

  switch (toolnum)
  {
    case TOOL_ROT:
      gv_event_mode(OBJROTATE);
      break;
    case TOOL_ZOOM:
      gv_event_mode(OBJZOOM);
      break;
    case TOOL_TRANS:
      gv_event_mode(OBJTRANSLATE);
      break;
    case TOOL_FLY:
      gv_event_mode(OBJFLY);
      break;
    case TOOL_ORBIT:
      gv_event_mode(OBJORBIT);
      break;
    case TOOL_SCALE:
      gv_event_mode(OBJSCALE);
      break;
    default:
      break;
  }
}

/*****************************************************************************/

static void action_callback(Widget w, XtPointer data,
				XmPushButtonCallbackStruct *cbs)
{
  int val = (int) data;
  int id = uistate.targetid;

  switch (val)
  {
    case ACTION_STOP:
      drawer_stop(NOID);
      ui_action(ACTION_STOP);
      break;
    case ACTION_LOOK:
      gv_look(GEOMID(uistate.targetgeom), CAMID(uistate.targetcam));
      ui_action(ACTION_LOOK);
      break;
    case ACTION_CENTER:
      drawer_center(id);
      ui_action(ACTION_CENTER);
      break;
    case ACTION_RESET:
      drawer_center(NOID);
      ui_action(ACTION_RESET);
      break;
    default:
      break;
  }
}

/*****************************************************************************/

static void load_tool_bitmaps(mib_Widget *toolload)
{
  Pixmap button_pix, rev_pix;
  Widget button;
  int    depth, bitdepth;
  Pixel  blue, red, white;

#ifdef MGX11
  mgctxget(MG_BITDEPTH, &bitdepth);

  if (bitdepth == 1)
  {
    blue = BlackPixel(dpy, DefaultScreen(dpy));
    red = BlackPixel(dpy, DefaultScreen(dpy));
    white = WhitePixel(dpy, DefaultScreen(dpy));
  }
  else
  if (bitdepth == 24)
  {
    XColor col;

    col.red = (unsigned short)0;
    col.green = (unsigned short)0;
    col.blue = (unsigned short)65535;
    if (XAllocColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)), &col))
      blue = col.pixel;
    else
      blue = BlackPixel(dpy, DefaultScreen(dpy));

    col.red = (unsigned short)65535;
    col.blue = (unsigned short)0;
    if (XAllocColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)), &col))
      red = col.pixel;
    else
      red = BlackPixel(dpy, DefaultScreen(dpy));

    col.blue = (unsigned short)65535;
    col.green = (unsigned short)65535;
    if (XAllocColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)), &col))
      white = col.pixel;
    else
      white = WhitePixel(dpy, DefaultScreen(dpy));

  }
  else
  {
#endif

    blue = ui_nearestRGB(0.0, 0.0, 1.0);
    red = ui_nearestRGB(1.0, 0.0, 0.0);
    white = ui_nearestRGB(1.0, 1.0, 1.0);

#ifdef MGX11
  }
#endif

/*****************************************************************************/

  button = mib_find_name(toolload, "RotateButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		rotate_bits, rotate_width, rotate_height, blue, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		rotate_bits, rotate_width, rotate_height, white, blue, depth);

  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, rev_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_ROT][0] = button_pix;
  toolpix[TOOL_ROT][1] = rev_pix;
  toolwidget[TOOL_ROT] = button;

  last = button;
  last_button = TOOL_ROT;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_ROT);


/*****************************************************************************/

  button = mib_find_name(toolload, "TranslateButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		translate_bits, translate_width, translate_height, blue, white,
		depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		translate_bits, translate_width, translate_height, white, blue,
		depth);

  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_TRANS][0] = button_pix;
  toolpix[TOOL_TRANS][1] = rev_pix;
  toolwidget[TOOL_TRANS] = button;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_TRANS);


/*****************************************************************************/

  button = mib_find_name(toolload, "ScaleButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		scale_bits, scale_width, scale_height, blue, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		scale_bits, scale_width, scale_height, white, blue, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_SCALE][0] = button_pix;
  toolpix[TOOL_SCALE][1] = rev_pix;
  toolwidget[TOOL_SCALE] = button;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_SCALE);

/*****************************************************************************/

  button = mib_find_name(toolload, "FlyButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		fly_bits, fly_width, fly_height, blue, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		fly_bits, fly_width, fly_height, white, blue, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_FLY][0] = button_pix;
  toolpix[TOOL_FLY][1] = rev_pix;
  toolwidget[TOOL_FLY] = button;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_FLY);

/*****************************************************************************/

  button = mib_find_name(toolload, "ZoomButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		zoom_bits, zoom_width, zoom_height, blue, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		zoom_bits, zoom_width, zoom_height, white, blue, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_ZOOM][0] = button_pix;
  toolpix[TOOL_ZOOM][1] = rev_pix;
  toolwidget[TOOL_ZOOM] = button;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_ZOOM);

/*****************************************************************************/

  button = mib_find_name(toolload, "OrbitButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		orbit_bits, orbit_width, orbit_height, blue, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		orbit_bits, orbit_width, orbit_height, white, blue, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  toolpix[TOOL_ORBIT][0] = button_pix;
  toolpix[TOOL_ORBIT][1] = rev_pix;
  toolwidget[TOOL_ORBIT] = button;

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) modetool_callback,
			(XtPointer)TOOL_ORBIT);

/*****************************************************************************/

  button = mib_find_name(toolload, "StopButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		stop_bits, stop_width, stop_height, red, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		stop_bits, stop_width, stop_height, white, red, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
			XmNarmPixmap, rev_pix, NULL);

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) action_callback,
			(XtPointer)ACTION_STOP);

/*****************************************************************************/

  button = mib_find_name(toolload, "LookAtButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                lookat_bits, lookat_width, lookat_height, red, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                lookat_bits, lookat_width, lookat_height, white, red, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
                        XmNarmPixmap, rev_pix, NULL);

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) action_callback,
			(XtPointer)ACTION_LOOK);

/*****************************************************************************/

  button = mib_find_name(toolload, "CenterButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                center_bits, center_width, center_height, red, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                center_bits, center_width, center_height, white, red, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
                        XmNarmPixmap, rev_pix, NULL);

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) action_callback,
			(XtPointer)ACTION_CENTER);

/*****************************************************************************/

  button = mib_find_name(toolload, "ResetButton")->me;
  XtVaGetValues(button, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                reset_bits, reset_width, reset_height, red, white, depth);
  rev_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
                reset_bits, reset_width, reset_height, white, red, depth);
  XtVaSetValues(button, XmNlabelType, XmPIXMAP, XmNlabelPixmap, button_pix,
                        XmNarmPixmap, rev_pix, NULL);

  XtAddCallback(button, XmNarmCallback, (XtCallbackProc) action_callback,
			(XtPointer)ACTION_RESET);

}

/*****************************************************************************/

static void target_set(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  char *str;
  int   id;

  str = XmTextFieldGetString(w);
  if ((id = drawer_idbyname(str)))
    set_ui_target_id(id);
  ui_select(uistate.targetid);
  XtFree(str);
}

/*****************************************************************************/

void ui_tool_targetset(char *target)
{
  char *str;

  if (!tools_loaded)
    return;

  str = XmTextFieldGetString(TargetText);

  if (strcmp(target, str))
    XmTextFieldSetString(TargetText, target);

  XtFree(str);
}

/*****************************************************************************/

static void center_set(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  char *str;
  int   id;

  str = XmTextFieldGetString(w);
  if ((id = drawer_idbyname(str)))
    set_ui_center(id);
  ui_select(uistate.centerid);
  XtFree(str);
}

/*****************************************************************************/

void ui_tool_centerset(char *center)
{
  char *str;

  if (!tools_loaded)
    return;

  str = XmTextFieldGetString(CenterText);

  if (strcmp(center,str))
    XmTextFieldSetString(CenterText, center);

  XtFree(str);
}

/*****************************************************************************/

