#include "mibload.h"
#include "mibwidgets.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "../common/comm.h"
#include "../common/worldio.h"
#include "../common/lang.h"
#include "gvui.h"
#include "interface/Save.mib"

extern Display *dpy;
extern Widget TopLevel;

/* private methods and variables */
/*****************************************************************************/

static void hide_savepanel(Widget, XtPointer, XmAnyCallbackStruct *);
static void select_type(Widget, XtPointer, XmAnyCallbackStruct *);
static void save_selection(Widget, XtPointer,
			XmFileSelectionBoxCallbackStruct *);
static int  suitable_id(int, char **);
static Widget shell, saveobj, geomobj, saveform;
static int    savechoice = 0;
static int    loaded = 0;
static int    pos_later = 0, posx = 0, posy = 0;
static int    oldstderr;

#define SAVE_WIO        0
#define SAVE_RMan       1
#define SAVE_SNAP       2
#define SAVE_PANELS     3

static struct saveops {
    int special;
    HandleOps *ops;
    int flag;
    char *name;
} save[] = {
    { SAVE_WIO, &CommandOps,    0,              "Commands"              },
    { SAVE_WIO, &GeomOps,       SELF,           "Geometry alone"        },
    { SAVE_WIO, &GeomOps,       WORLDGEOM,      "Geometry [in world]"   },
    { SAVE_WIO, &GeomOps,       UNIVERSE,       "Geometry [in universe]" },
    { SAVE_RMan, NULL,          TIFF_KEYWORD,   "RMan [->tiff]"         },
    { SAVE_RMan, NULL,          FRAME_KEYWORD,  "RMan [->frame]"        },
    { SAVE_WIO, &CamOps,        UNIVERSE,       "Camera"                },
    { SAVE_WIO, &TransOps,      WORLDGEOM,      "Transform [to world]"  },
    { SAVE_WIO, &TransOps,      UNIVERSE,       "Transform [to universe]"},
    { SAVE_WIO, &WindowOps,     UNIVERSE,       "Window"                },
};


/*****************************************************************************/

void ui_load_savepanel()
{
  Arg	     args[20];
  int	     n;
  Widget     savetypeform,
	     temp;

  mib_Widget *savetypeload,
	     *m_saveobj;
  mib_Menu   *objectmenu;
  XmString   label_text;
  Atom       AProtocol;
  XmString   xname;

/*****************************************************************************/

#ifdef SVR4             /* is this solaris? */
                        /* if so, lets work around a dumb motif bug here */
  n = 0;
  XtSetArg(args[n], XmNtitle, "Save"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 340); n++;
  XtSetArg(args[n], XmNminWidth, 340); n++;
  XtSetArg(args[n], XmNheight, 480); n++;
  XtSetArg(args[n], XmNminHeight, 392); n++;

  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  shell = XtAppCreateShell("Load", "gv", topLevelShellWidgetClass,
                                dpy, args, n);

#endif

/*****************************************************************************/

  n = 0;

  XtSetArg(args[n], XmNtitle, "Save"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 340); n++;
  XtSetArg(args[n], XmNminWidth, 340); n++;
  XtSetArg(args[n], XmNheight, 480); n++;
  XtSetArg(args[n], XmNminHeight, 392); n++;

  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

#ifdef SVR4
  saveform = XmCreateFileSelectionBox(shell, "Save", args, n);
  XtManageChild(saveform);
#else
  saveform = XmCreateFileSelectionDialog(TopLevel, "Save", args, n);
#endif
 
/*****************************************************************************/

  temp = XmFileSelectionBoxGetChild(saveform, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);

  XtAddCallback(saveform, XmNokCallback, (XtCallbackProc) save_selection,
		(XtPointer) NULL);

  temp = XmFileSelectionBoxGetChild(saveform, XmDIALOG_CANCEL_BUTTON);

  xname = XmStringCreateSimple("Hide");
  XtVaSetValues(temp, XmNlabelString, xname, NULL);
  XmStringFree(xname);

  XtAddCallback(temp, XmNactivateCallback, (XtCallbackProc) hide_savepanel,
		(XtPointer) NULL);

/*****************************************************************************/

/*savetypeload = mib_load_interface(saveform, "interface/Save.mib",
			MI_FROMFILE);*/
  savetypeload = mib_load_interface(saveform, Root,
			MI_FROMSTRING);
  savetypeform = savetypeload->me;

  m_saveobj  = mib_find_name(savetypeload, "ObjectMenu");
  saveobj    = m_saveobj->me;
  objectmenu = (mib_Menu *)m_saveobj->myres;

  label_text = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
  XtVaSetValues(saveobj, XmNlabelString, label_text, NULL);
  XmStringFree(label_text);

  for (n = 0; n < objectmenu->numitems; n++)
  {
    XtAddCallback(objectmenu->items[n], XmNactivateCallback,
			(XtCallbackProc) select_type, (XtPointer) n);
  }

  geomobj    = mib_find_name(savetypeload, "Object")->me;
  XmTextFieldSetString(geomobj, "World");

  XtManageChild(savetypeform);

/*****************************************************************************/

#ifdef SVR4
  AProtocol = XmInternAtom(XtDisplay(shell), "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol,
			(XtCallbackProc) hide_savepanel, (XtPointer) NULL);
#else
  AProtocol = XmInternAtom(XtDisplay(saveform), "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(XtParent(saveform), AProtocol,
			(XtCallbackProc) hide_savepanel, (XtPointer) NULL);
#endif

  loaded = 1;
}

/*****************************************************************************/

void ui_show_savepanel()
{
  if (!loaded)
  {
    oldstderr = dup(fileno(stderr));
    freopen("/dev/null", "w", stderr);

    ui_load_savepanel();

    freopen("/dev/null", "w", stderr);
    dup2(oldstderr, fileno(stderr));
    close(oldstderr);
  }

/*
  if (pos_later)
  {
    XtMoveWidget(saveform, (Position)posx, (Position)posy);
    pos_later = 0;
  }
*/

#ifdef SVR4
  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
#else
  XtManageChild(saveform);
  XRaiseWindow(dpy, XtWindow(saveform));
#endif

}

/*****************************************************************************/

void ui_hide_savepanel()
{
  if (!loaded)
    return;

#ifdef SVR4
  XtUnrealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
#else
  XtUnmanageChild(saveform);
  XRaiseWindow(dpy, XtWindow(saveform));
#endif

}

/*****************************************************************************/

void ui_move_savepanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(saveform, (Position)x, (Position)y);
}

/*****************************************************************************/

static void hide_savepanel(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_SAVE, 0);
}

/*****************************************************************************/

static int suitable_id(int savetype, char **namep)
{
   struct saveops *sp = &save[savetype];
   int id = drawer_idbyname(*namep);

   if(savetype >= 0 && savetype < COUNT(save)) {
        if(sp->ops == &CamOps || sp->ops == &WindowOps
                            || sp->special == SAVE_RMan
                            || sp->special == SAVE_SNAP) {
            if(!ISCAM(id)) id = FOCUSID;
        } else if(sp->ops == &GeomOps && !ISGEOM(id))
            id = GEOMID(uistate.targetgeom);
   }
   *namep = drawer_id2name(id);
   return (drawer_get_object(id) == NULL) ? NOID : id;
}

/*****************************************************************************/

static void select_type(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  savechoice = (int)data;
}

/*****************************************************************************/

static void save_selection(Widget w, XtPointer data,
		XmFileSelectionBoxCallbackStruct *cbs)
{

  char *fname, *object;
  int   id;
  Pool *p;
  struct saveops *sp;

  if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
    return;

  if (!*fname)
    return;

  object = XmTextFieldGetString(geomobj);

  if(fname == NULL || object == NULL || *fname == '\0' || *object == '\0'
                   || savechoice < 0)
  {
    XtFree(fname);
    XtFree(object);
    return;
  }
  if((id = suitable_id(savechoice, &object)) == NOID) {
    XmTextFieldSetString(geomobj, "?");
    XtFree(fname);
    XtFree(object);
    return;
  }
  sp = &save[savechoice];
  switch(sp->special) {
  case SAVE_WIO:
    p = PoolStreamTemp(fname, (!strcmp(fname,"-"))?stdout:NULL, 1, sp->ops);
    if(p == NULL) {
        fprintf(stderr, "Can't open output: %s: %s\n", fname, sperror());
        return;
    }
    worldio(sp->ops, p, sp->flag, id);
    if(PoolOutputFile(p) != stdout) PoolClose(p);
    PoolDelete(p);
    break;
  case SAVE_RMan:
    gv_rib_display(sp->flag, fname);
    gv_rib_snapshot(id, fname);
    break;
  case SAVE_SNAP:
    /* Do nothing ... yet :-) */
    break;
  case SAVE_PANELS:
    /* Do nothing ... yet :-) */
    break;
  }
  ui_showpanel(P_SAVE, 0);
  uistate.savewhat = NOID;

}

/*****************************************************************************/
